package com.atlassian.marketplace.client.model;

import com.atlassian.marketplace.client.util.ModelUtil;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * Used internally due to the slightly odd JSON schema of some API objects.
 */
final class KeyValuePair
{
    @JsonProperty private final String key;
    @JsonProperty private final String value;

    @JsonCreator
    KeyValuePair(@JsonProperty("key") String key, @JsonProperty("value") String value)
    {
        this.key = ModelUtil.requireProperty(key, "key");
        this.value = ModelUtil.requireProperty(value, "value");
    }
    
    String getKey()
    {
        return key;
    }
    
    String getValue()
    {
        return value;
    }
}
