package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * Information about a banner image associated with a plugin.
 */
public final class Banner
{
    @JsonProperty private final String pluginKey;
    @JsonProperty private final Image image;
    @JsonProperty private final Image carouselImage;
    
    // fields omitted:  approved
    
    @JsonCreator
    Banner(@JsonProperty("pluginKey") String pluginKey,
           @JsonProperty("image") Image image,
           @JsonProperty("carouselImage") Image carouselImage)
    {
        this.pluginKey = requireProperty(pluginKey, "pluginKey");
        this.image = requireProperty(image, "image");
        this.carouselImage = carouselImage;  // optional
    }

    /**
     * The plugin key.
     */
    public String getPluginKey()
    {
        return pluginKey;
    }
    
    /**
     * The full banner image.
     */
    public Image getImage()
    {
        return image;
    }

    /**
     * A smaller version of the image to display in a carousel.
     */
    @JsonIgnore
    public Option<Image> getCarouselImage()
    {
        return option(carouselImage);
    }
}
