package com.atlassian.marketplace.client.model;

import java.util.Date;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Information about a specific version of an Atlassian application.
 */
public final class ApplicationVersion
{
    @JsonProperty private final Links links;
    @JsonProperty private final long buildNumber;
    @JsonProperty private final String version;
    @JsonProperty private final Date releaseDate;
    @JsonProperty private final KeyValuePair status;
    
    // fields omitted: status
    
    @JsonCreator
    ApplicationVersion(@JsonProperty("links") Links links,
                       @JsonProperty("buildNumber") long buildNumber,
                       @JsonProperty("version") String version,
                       @JsonProperty("releaseDate") Date releaseDate,
                       @JsonProperty("status") KeyValuePair status)
    {
        this.links = requireProperty(links, "links");
        this.buildNumber = requireProperty(buildNumber, "buildNumber");
        this.version = requireProperty(version, "version");
        this.releaseDate = requireProperty(releaseDate, "releaseDate");
        this.status = requireProperty(status, "status");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The unique build number of this application version.
     */
    public long getBuildNumber()
    {
        return buildNumber;
    }

    /**
     * The version string (e.g. "1.0").
     */
    public String getVersion()
    {
        return version;
    }

    /**
     * The date when this version became available.
     */
    public Date getReleaseDate()
    {
        return releaseDate;
    }
    
    /**
     * True if this application version is visible on the website and can be used in plugin
     * compatibility settings.
     */
    public boolean isPublished()
    {
        return status.getValue().equalsIgnoreCase("published");
    }
}
