package com.atlassian.marketplace.client.impl.representations;

import java.util.Collection;

import com.atlassian.marketplace.client.model.Links;
import com.atlassian.marketplace.client.model.PluginSummary;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Entity returned by the MPAC root resource, containing only a links map.
 */
public class PluginsRepresentation
{
    @JsonProperty private final Links links;
    @JsonProperty private final Collection<PluginSummary> plugins;
    @JsonProperty private final int count;

    @JsonCreator
    public PluginsRepresentation(@JsonProperty("links") Links links,
                                 @JsonProperty("plugins") Collection<PluginSummary> plugins,
                                 @JsonProperty("count") Integer count)
    {
        this.links = requireProperty(links, "links");
        this.plugins = requireList(plugins, "plugins");
        this.count = (count == null) ? plugins.size() : count;  // server doesn't currently give us this (AMKT-2649)
    }
    
    public Links getLinks()
    {
        return links;
    }
    
    @JsonIgnore
    public Iterable<PluginSummary> getPlugins()
    {
        return ImmutableList.copyOf(plugins);
    }
    
    public int getCount()
    {
        return count;
    }
}
