package com.atlassian.marketplace.client.impl.representations;

import java.util.Collection;

import com.atlassian.marketplace.client.model.PluginCategory;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Entity returned by the /categories/app/APPKEY resource.
 */
public class PluginCategoriesByAppRepresentation
{
    @JsonProperty private final String name;
    @JsonProperty private final String key;
    @JsonProperty private final Collection<PluginCategory> categories;

    @JsonCreator
    public PluginCategoriesByAppRepresentation(@JsonProperty("name") String name,
                                               @JsonProperty("key") String key,
                                               @JsonProperty("categories") Collection<PluginCategory> categories)
    {
        this.name = requireProperty(name, "name");
        this.key = requireProperty(key, "key");
        this.categories = requireList(categories, "categories");
    }
    
    public String getName()
    {
        return name;
    }

    public String getKey()
    {
        return key;
    }

    @JsonIgnore
    public Iterable<PluginCategory> getCategories()
    {
        return ImmutableList.copyOf(categories);
    }
}
