package com.atlassian.marketplace.client.impl;

import java.net.URI;

import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.model.Links;
import com.atlassian.upm.api.util.Option;

import static com.atlassian.marketplace.client.impl.representations.RepresentationLinks.NEXT_REL;
import static com.atlassian.marketplace.client.impl.representations.RepresentationLinks.PREVIOUS_REL;
import static com.atlassian.upm.api.util.Option.none;
import static com.atlassian.upm.api.util.Option.some;
import static com.google.common.base.Preconditions.checkNotNull;

final class PageImpl<T> extends Page<T>
{
    private final PageReference<T> reference;
    private final Option<URI> previousUri;
    private final Option<URI> nextUri;
    
    PageImpl(PageReference<T> reference, Links links, Iterable<T> items, int count)
    {
        super(items, count);
        this.reference = checkNotNull(reference, "reference");
        checkNotNull(links, "links");
        this.previousUri = links.get(PREVIOUS_REL);
        this.nextUri = links.get(NEXT_REL);
    }

    @Override
    public Option<PageReference<T>> getReference()
    {
        return some(reference);
    }
    
    @Override
    public Option<PageReference<T>> getPrevious()
    {
        for (URI p: previousUri)
        {
            return some(new PageReference<T>(p, reference.getOffset() - reference.getLimit().getOrElse(size()),
                reference.getLimit().orElse(some(size()))));
        }
        return none();
    }

    @Override
    public Option<PageReference<T>> getNext()
    {
        for (URI n: nextUri)
        {
            return some(new PageReference<T>(n, reference.getOffset() + reference.getLimit().getOrElse(size()),
                        reference.getLimit().orElse(some(size()))));
        }
        return none();
    }
}
