package com.atlassian.marketplace.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.atlassian.marketplace.client.MpacException;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

/**
 * Jackson-based implementation of JSON encoding.
 */
public final class JsonEntityEncoding implements EntityEncoding
{
    private final ObjectMapper mapper;
    
    public JsonEntityEncoding()
    {
        mapper = new ObjectMapper(new MappingJsonFactory());
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public <T> T decode(InputStream stream, Class<T> type) throws MpacException
    {
        try
        {
            return mapper.readValue(stream, type);
        }
        catch (IllegalArgumentException e)
        {
            throw new MpacException.InvalidResponseError(e.getMessage());
        }
        catch (JsonProcessingException e)
        {
            throw new MpacException.InvalidResponseError(e.getMessage());
        }
        catch (IOException e)
        {
            throw new MpacException(e);
        }
    }

    @Override
    public <T> void encode(OutputStream stream, T entity) throws MpacException
    {
        try
        {
            mapper.writeValue(stream, entity);
        }
        catch (IOException e)
        {
            throw new MpacException(e);
        }
    }
}
