/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.transformers.notification;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.upm.transformers.notification.NotificationsJavascriptVariableTransformer;
import com.atlassian.upm.transformers.notification.NotificationsPageDataFactory;
import com.atlassian.upm.transformers.webresource.LocaleUtils;
import com.atlassian.upm.transformers.webresource.UrlReadingWebResourceUrlBuilder;
import java.util.Locale;
import java.util.Objects;

public class UrlReadingNotificationWebResourceTransformer
implements WebResourceTransformerFactory {
    private final UrlReadingWebResourceUrlBuilder urlReadingWebResourceUrlBuilder;
    private final NotificationsPageDataFactory notificationsPageDataFactory;

    public UrlReadingNotificationWebResourceTransformer(UrlReadingWebResourceUrlBuilder urlReadingWebResourceUrlBuilder, NotificationsPageDataFactory notificationsPageDataFactory) {
        this.notificationsPageDataFactory = Objects.requireNonNull(notificationsPageDataFactory);
        this.urlReadingWebResourceUrlBuilder = Objects.requireNonNull(urlReadingWebResourceUrlBuilder);
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return new NotificationTransformerUrlBuilder();
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return new NotificationWebResourceTransformer();
    }

    private final class NotificationTransformerUrlBuilder
    implements TransformerUrlBuilder {
        private NotificationTransformerUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            UrlReadingNotificationWebResourceTransformer.this.urlReadingWebResourceUrlBuilder.build(urlBuilder);
        }
    }

    private final class NotificationDownloadableResource
    extends CharSequenceDownloadableResource {
        private final Locale locale;

        private NotificationDownloadableResource(DownloadableResource originalResource, Locale locale) {
            super(originalResource);
            this.locale = locale;
        }

        protected CharSequence transform(CharSequence originalContent) {
            return NotificationsJavascriptVariableTransformer.replaceVars(originalContent.toString(), UrlReadingNotificationWebResourceTransformer.this.notificationsPageDataFactory.generate(this.locale));
        }
    }

    private final class NotificationWebResourceTransformer
    implements UrlReadingWebResourceTransformer {
        private NotificationWebResourceTransformer() {
        }

        public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
            Locale locale = LocaleUtils.deserialize(params.get("locale"));
            return new NotificationDownloadableResource(transformableResource.nextResource(), locale);
        }
    }
}

