/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.transformers.notification;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class NotificationsPageDataFactory {
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;

    public NotificationsPageDataFactory(ApplicationProperties applicationProperties, I18nResolver i18nResolver) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        this.i18nResolver = Objects.requireNonNull(i18nResolver, "i18nResolver");
    }

    public Map<String, Object> generate(Locale locale) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("productId", this.applicationProperties.getDisplayName().toLowerCase());
        props.put("onDemand", false);
        props.put("pluginNotificationsTitle", this.i18nResolver.getText(locale, "upm.notification.plugin.notifications"));
        props.put("noNotificationsText", this.i18nResolver.getText(locale, "upm.notification.no.notifications"));
        props.put("analyticsUrl", this.newPluginBaseUriBuilder().path("/analytics").build(new Object[0]).toASCIIString());
        props.put("rootNotificationsUrl", this.newPluginBaseUriBuilder().path("/notifications").build(new Object[0]).toASCIIString());
        return Collections.unmodifiableMap(props);
    }

    private UriBuilder newPluginBaseUriBuilder() {
        return this.newApplicationBaseUriBuilder().path("/rest/plugins/1.0");
    }

    private UriBuilder newApplicationBaseUriBuilder() {
        URI base = URI.create(this.applicationProperties.getBaseUrl()).normalize();
        return UriBuilder.fromPath((String)base.getPath());
    }
}

