/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.topology;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.topology.InstanceTopologyService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTopologyUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(InstanceTopologyUpgradeTask.class);
    private final UpmInformation upm;
    private final InstanceTopologyService instanceTopologyService;

    public InstanceTopologyUpgradeTask(UpmInformation upm, InstanceTopologyService instanceTopologyService) {
        this.upm = upm;
        this.instanceTopologyService = instanceTopologyService;
    }

    public int getBuildNumber() {
        return 5;
    }

    public String getShortDescription() {
        return "Posts an initial topology report for a new UPM instance.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Running UPM instance topology report upgrade task. No actual upgrade is being performed.");
        try {
            this.instanceTopologyService.sendInstanceTopologyData();
        }
        catch (Exception e) {
            log.error("Error sending instance topology data", (Throwable)e);
        }
        return null;
    }

    public String getPluginKey() {
        return this.upm.getPluginKey();
    }
}

