/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.topology;

import com.atlassian.extras.api.LicenseType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.api.license.entity.LicenseEditionType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.jwt.JwtTokenFactory;
import com.atlassian.upm.jwt.UpmJwtToken;
import com.atlassian.upm.license.internal.HostApplicationLicense;
import com.atlassian.upm.license.internal.HostLicenseProvider;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.rest.representations.InstanceTopologyRepresentation;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.atlassian.upm.topology.InstanceTopology;
import com.atlassian.upm.topology.InstanceTopologyFactory;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTopologyFactoryImpl
implements InstanceTopologyFactory {
    private static final Logger log = LoggerFactory.getLogger(InstanceTopologyFactoryImpl.class);
    private final ApplicationProperties applicationProperties;
    private final PluginRetriever pluginRetriever;
    private final PluginLicenseRepository licenseRepository;
    private final UpmInformation upmInformation;
    private final HostLicenseProvider hostLicenseProvider;
    private final HostApplicationDescriptor hostApplicationDescriptor;
    private final UpmRepresentationFactory representationFactory;
    private final JwtTokenFactory jwtTokenFactory;
    private final LicenseHandler licenseHandler;
    private final ObjectMapper mapper;
    private final UpmAppManager appManager;
    private static Comparator<InstanceTopology.InstanceTopologyProduct> productsByKey = new Comparator<InstanceTopology.InstanceTopologyProduct>(){

        @Override
        public int compare(InstanceTopology.InstanceTopologyProduct prod1, InstanceTopology.InstanceTopologyProduct prod2) {
            return prod1.getLicense().getKey().compareTo(prod2.getLicense().getKey());
        }
    };

    public InstanceTopologyFactoryImpl(ApplicationProperties applicationProperties, PluginRetriever pluginRetriever, PluginLicenseRepository licenseRepository, UpmInformation upmInformation, HostLicenseProvider hostLicenseProvider, HostApplicationDescriptor hostApplicationDescriptor, UpmRepresentationFactory representationFactory, JwtTokenFactory jwtTokenFactory, LicenseHandler licenseHandler, UpmAppManager appManager) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.upmInformation = (UpmInformation)Preconditions.checkNotNull((Object)upmInformation, (Object)"upmInformation");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.hostLicenseProvider = (HostLicenseProvider)Preconditions.checkNotNull((Object)hostLicenseProvider, (Object)"hostLicenseProvider");
        this.hostApplicationDescriptor = (HostApplicationDescriptor)Preconditions.checkNotNull((Object)hostApplicationDescriptor, (Object)"hostApplicationDescriptor");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.jwtTokenFactory = (JwtTokenFactory)Preconditions.checkNotNull((Object)jwtTokenFactory, (Object)"jwtTokenFactory");
        this.licenseHandler = (LicenseHandler)Preconditions.checkNotNull((Object)licenseHandler, (Object)"licenseHandler");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
    }

    @Override
    public Option<InstanceTopology> generateTopology() {
        Iterator<String> iterator = Option.option(this.licenseHandler.getServerId()).iterator();
        if (iterator.hasNext()) {
            String serverId = iterator.next();
            URI instanceUrl = URI.create(this.applicationProperties.getBaseUrl());
            String instanceName = this.applicationProperties.getDisplayName();
            String platformVersion = this.applicationProperties.getVersion();
            String client = this.upmInformation.getPluginKey();
            String clientVersion = this.upmInformation.getVersionString();
            Option<String> cloud = Option.none();
            BuiltProducts builtProducts = this.buildProducts();
            ImmutableList<InstanceTopology.InstanceTopologyAddon> addons = this.buildAddons();
            return Option.some(new InstanceTopology(serverId, instanceName, instanceUrl, cloud, platformVersion, client, clientVersion, (Iterable<InstanceTopology.InstanceTopologyProduct>)builtProducts.products, (Iterable<InstanceTopology.InstanceTopologyAddon>)addons, builtProducts.active, builtProducts.licensed));
        }
        return Option.none(InstanceTopology.class);
    }

    private BuiltProducts buildProducts() {
        int active = 0;
        int licensed = 0;
        ImmutableList.Builder products = ImmutableList.builder();
        for (HostApplicationLicense hostLicense : this.hostLicenseProvider.getHostApplicationLicenses()) {
            for (String sen : hostLicense.getSen()) {
                boolean installed = false;
                int numberOfActiveUsers = 0;
                Option<String> version = Option.none(String.class);
                for (UpmAppManager.ApplicationInfo appInfo : this.appManager.getApplication(hostLicense.getProductKey())) {
                    installed = true;
                    numberOfActiveUsers = appInfo.numberOfActiveUsers;
                    version = Option.some(appInfo.version);
                }
                if (!hostLicense.isEvaluation()) {
                    active += numberOfActiveUsers;
                    licensed += hostLicense.getEdition().getOrElse(0).intValue();
                }
                InstanceTopology.InstanceTopologyLicense license = new InstanceTopology.InstanceTopologyLicense(sen, hostLicense.getEncodedProductKey(), hostLicense.getProductName(), hostLicense.isEvaluation(), installed, InstanceTopologyFactoryImpl.getInstanceTopologyLicenseType(hostLicense.getLicenseType()), hostLicense.isRoleBased() ? InstanceTopology.InstanceTopologyEditionType.ROLE_COUNT : InstanceTopology.InstanceTopologyEditionType.USER_COUNT, version, hostLicense.isDataCenter(), numberOfActiveUsers, hostLicense.getEdition().getOrElse(-1), new DateTime((Object)hostLicense.getPurchaseDate()));
                products.add((Object)new InstanceTopology.InstanceTopologyProduct(license, hostLicense.getRawLicense().replaceAll("\n|\r", "")));
            }
        }
        return new BuiltProducts(active, licensed, (ImmutableList<InstanceTopology.InstanceTopologyProduct>)products.build());
    }

    private ImmutableList<InstanceTopology.InstanceTopologyAddon> buildAddons() {
        ImmutableList.Builder addons = ImmutableList.builder();
        for (PluginLicense addonLicense : this.licenseRepository.getPluginLicenses()) {
            for (String sen : addonLicense.getSupportEntitlementNumber()) {
                InstanceTopology.InstanceTopologyLicense license = new InstanceTopology.InstanceTopologyLicense(sen, addonLicense.getPluginKey(), addonLicense.getPluginName(), addonLicense.isEvaluation(), this.pluginRetriever.isPluginInstalled(addonLicense.getPluginKey()), InstanceTopologyFactoryImpl.getInstanceTopologyLicenseType(addonLicense.getLicenseType()), InstanceTopologyFactoryImpl.getInstanceTopologyEditionType(addonLicense.getEditionType()), this.getPluginVersion(addonLicense.getPluginKey()), addonLicense.isDataCenter(), this.hostApplicationDescriptor.getActiveEditionCount(), addonLicense.getEdition().getOrElse(-1), new DateTime((Object)addonLicense.getPurchaseDate()));
                addons.add((Object)new InstanceTopology.InstanceTopologyAddon(license, addonLicense.isValid(), addonLicense.isActive(), addonLicense.getError()));
            }
        }
        return addons.build();
    }

    private static InstanceTopology.InstanceTopologyLicenseType getInstanceTopologyLicenseType(LicenseType type) {
        switch (type) {
            case ACADEMIC: {
                return InstanceTopology.InstanceTopologyLicenseType.ACADEMIC;
            }
            case COMMERCIAL: {
                return InstanceTopology.InstanceTopologyLicenseType.COMMERCIAL;
            }
        }
        return InstanceTopology.InstanceTopologyLicenseType.DEVELOPER;
    }

    private static InstanceTopology.InstanceTopologyLicenseType getInstanceTopologyLicenseType(com.atlassian.upm.api.license.entity.LicenseType type) {
        switch (type) {
            case ACADEMIC: {
                return InstanceTopology.InstanceTopologyLicenseType.ACADEMIC;
            }
            case COMMERCIAL: {
                return InstanceTopology.InstanceTopologyLicenseType.COMMERCIAL;
            }
        }
        return InstanceTopology.InstanceTopologyLicenseType.DEVELOPER;
    }

    private static InstanceTopology.InstanceTopologyEditionType getInstanceTopologyEditionType(LicenseEditionType type) {
        switch (type) {
            case REMOTE_AGENT_COUNT: {
                return InstanceTopology.InstanceTopologyEditionType.REMOTE_AGENT_COUNT;
            }
            case ROLE_COUNT: {
                return InstanceTopology.InstanceTopologyEditionType.ROLE_COUNT;
            }
            case USER_COUNT: {
                return InstanceTopology.InstanceTopologyEditionType.USER_COUNT;
            }
        }
        throw new IllegalArgumentException("Unknown edition type: " + (Object)((Object)type));
    }

    @Override
    public Option<UpmJwtToken> generateJwtToken() {
        return this.generateTopology().map(new Function<InstanceTopology, UpmJwtToken>(){

            public UpmJwtToken apply(InstanceTopology topology) {
                return InstanceTopologyFactoryImpl.this.generateJwtToken(topology);
            }
        });
    }

    @Override
    public UpmJwtToken generateJwtToken(InstanceTopology topo) {
        String sharedSecret = this.generateSharedSecret(topo);
        Map<String, String> claims = this.generateClaims(topo);
        InstanceTopologyRepresentation postBody = this.representationFactory.createInstanceTopologyRepresentation(topo);
        return this.jwtTokenFactory.generateToken(sharedSecret, claims, Option.some(postBody));
    }

    private String generateSharedSecret(InstanceTopology topo) {
        List sortedProductLicenses = Ordering.from(productsByKey).sortedCopy(topo.getProductLicenses());
        List licenseKeys = Lists.transform((List)sortedProductLicenses, (Function)new Function<InstanceTopology.InstanceTopologyProduct, String>(){

            public String apply(InstanceTopology.InstanceTopologyProduct product) {
                return product.getLicenseKey();
            }
        });
        return Joiner.on((String)".").join((Iterable)licenseKeys);
    }

    private Map<String, String> generateClaims(InstanceTopology topo) {
        HashMap<String, String> claims = new HashMap<String, String>();
        List sortedProductLicenses = Ordering.from(productsByKey).sortedCopy(topo.getProductLicenses());
        for (InstanceTopology.InstanceTopologyProduct product : sortedProductLicenses) {
            TopologyClaim claim = new TopologyClaim(product.getLicense().getSen(), product.getLicense().getPurchaseDate().getMillis());
            try {
                claims.put(product.getLicense().getKey(), this.mapper.writeValueAsString((Object)claim));
            }
            catch (IOException e) {
                log.warn("Failed to serialize JWT claim for SEN " + product.getLicense().getSen(), (Throwable)e);
            }
        }
        return ImmutableMap.copyOf(claims);
    }

    private Option<String> getPluginVersion(String pluginKey) {
        return this.pluginRetriever.getPlugin(pluginKey).map(new Function<Plugin, String>(){

            public String apply(Plugin plugin) {
                return plugin.getVersion();
            }
        });
    }

    private static class TopologyClaim {
        @JsonProperty
        private final String sen;
        @JsonProperty
        private final long purchaseDate;

        @JsonCreator
        public TopologyClaim(@JsonProperty(value="sen") String sen, @JsonProperty(value="purchaseDate") long purchaseDate) {
            this.sen = sen;
            this.purchaseDate = purchaseDate;
        }
    }

    private static class BuiltProducts {
        final int active;
        final int licensed;
        final ImmutableList<InstanceTopology.InstanceTopologyProduct> products;

        BuiltProducts(int a, int l, ImmutableList<InstanceTopology.InstanceTopologyProduct> ps) {
            this.active = a;
            this.licensed = l;
            this.products = ps;
        }
    }
}

