/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test.rest.resources;

import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/test/bundle-id")
public class BundleIdResource {
    private final PermissionEnforcer permissionEnforcer;
    private final UpmInformation upm;

    public BundleIdResource(PermissionEnforcer permissionEnforcer, UpmInformation upm) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getBundleId() {
        this.permissionEnforcer.enforceSystemAdmin();
        if (!UpmSys.isUpmDebugModeEnabled()) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        return Response.ok((Object)String.valueOf(this.upm.getBundleId())).build();
    }
}

