/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.spi;

import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class PluginInstallResult {
    private final Plugin plugin;
    private final Iterable<Plugin> dependencies;
    private final Iterable<Message> messages;

    public PluginInstallResult(Plugin plugin) {
        this(plugin, (Iterable<Plugin>)ImmutableList.of(), (Iterable<Message>)ImmutableList.of());
    }

    public PluginInstallResult(Plugin plugin, Iterable<Plugin> dependencies) {
        this(plugin, dependencies, (Iterable<Message>)ImmutableList.of());
    }

    public PluginInstallResult(Plugin plugin, Iterable<Plugin> dependencies, Iterable<Message> messages) {
        this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.dependencies = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(dependencies, (Object)"dependencies")));
        this.messages = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(messages, (Object)"messages")));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Iterable<Plugin> getDependencies() {
        return this.dependencies;
    }

    public Iterable<Message> getMessages() {
        return this.messages;
    }

    public static class Message {
        private final Level level;
        private final String message;

        public Message(Level level, String message) {
            this.level = (Level)((Object)Preconditions.checkNotNull((Object)((Object)level), (Object)"level"));
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum Level {
            INFO,
            WARNING;

        }
    }
}

