/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.servlet;

import com.atlassian.marketplace.client.model.Links;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSys;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.servlet.UpmServletHandler;
import com.atlassian.upm.license.internal.HostApplicationLicenseAttributes;
import com.atlassian.upm.license.internal.HostLicenseProvider;
import com.atlassian.upm.pac.PacClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class PluginManagerHandler
extends UpmServletHandler {
    public static final String SOURCE_PARAM = "source";
    public static final String SOURCE_TYPE_PARAM = "source-type";
    private final PermissionEnforcer permissionEnforcer;
    private final UpmInformation upm;
    private final SysPersisted sysPersisted;
    private final UpmHostApplicationInformation appInfo;
    private final UpmAppManager appManager;
    private final HostApplicationDescriptor hostApplicationDescriptor;
    private final HostLicenseProvider hostLicenseProvider;
    private final PacClient pacClient;

    public PluginManagerHandler(TemplateRenderer renderer, PermissionEnforcer permissionEnforcer, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, UpmInformation upm, SysPersisted sysPersisted, UpmHostApplicationInformation appInfo, UpmAppManager appManager, HostApplicationDescriptor hostApplicationDescriptor, HostLicenseProvider hostLicenseProvider, PacClient pacClient) {
        super(renderer, permissionEnforcer, loginUriProvider, webSudoManager);
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.appInfo = (UpmHostApplicationInformation)Preconditions.checkNotNull((Object)appInfo, (Object)"appInfo");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
        this.hostApplicationDescriptor = (HostApplicationDescriptor)Preconditions.checkNotNull((Object)hostApplicationDescriptor, (Object)"hostApplicationDescriptor");
        this.hostLicenseProvider = (HostLicenseProvider)Preconditions.checkNotNull((Object)hostLicenseProvider, (Object)"hostLicenseProvider");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest request) {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"pacWebsiteUrl", (Object)UpmSys.getMpacWebsiteBaseUrl());
        contextBuilder.put((Object)"upmVersion", (Object)this.upm.getVersion());
        contextBuilder.put((Object)"macBaseurl", (Object)UpmSys.getMacBaseUrl());
        contextBuilder.put((Object)"isOnDemand", (Object)false);
        contextBuilder.put((Object)"isApplicationApiSupported", (Object)this.appManager.isApplicationSupportEnabled());
        contextBuilder.put((Object)"licensedHostUsers", (Object)this.getLicensedHostUsers());
        contextBuilder.put((Object)"isPlatformFreeTier", (Object)false);
        contextBuilder.put((Object)"hostDataCenter", (Object)this.appInfo.isHostDataCenterEnabled());
        UpmHostApplicationInformation.AuiCapabilities ac = this.appInfo.getAuiCapabilities();
        if (ac != null) {
            contextBuilder.put((Object)"auiCapabilities", (Object)ac);
        }
        for (Links mpacLinks : this.pacClient.getMarketplaceRootLinks()) {
            for (URI uri : mpacLinks.getUri("addons")) {
                contextBuilder.put((Object)"mpacAddonsUrl", (Object)Sys.resolveMarketplaceUri(uri));
            }
        }
        return contextBuilder.build();
    }

    private int getLicensedHostUsers() {
        HostApplicationLicenseAttributes attrs = this.hostLicenseProvider.getHostApplicationLicenseAttributes();
        if (!attrs.isEvaluation()) {
            return attrs.getEdition().getOrElse(-1);
        }
        return 0;
    }
}

