/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.schedule;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.upm.lifecycle.UpmProductDataStartupComponent;
import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationType;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.DisposableBean;

public class NotificationCacheUpdateEventListener
implements UpmProductDataStartupComponent,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final NotificationCache cache;

    public NotificationCacheUpdateEventListener(EventPublisher eventPublisher, NotificationCache cache) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.cache = (NotificationCache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
    }

    @Override
    public void onStartupWithProductData() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginUninstalled(PluginUninstalledEvent event) {
        String pluginKey = event.getPlugin().getKey();
        for (NotificationType type : NotificationType.values()) {
            if (!type.isForInstalledPluginsOnly()) continue;
            this.cache.removeNotificationForPlugin(type, pluginKey);
        }
    }
}

