/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.schedule;

import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.schedule.AbstractUpmScheduledJob;
import com.atlassian.upm.schedule.UpmScheduler;
import com.atlassian.upm.topology.InstanceTopologyService;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class InstanceTopologyJob
extends AbstractUpmScheduledJob {
    private static final Random RANDOM = new Random(new Date().getTime());
    private static final int HOUR_OF_DAY_TO_RUN_AT = RANDOM.nextInt(24);
    private static final int MIN_OF_HOUR_TO_RUN_AT = RANDOM.nextInt(60);
    private static final int SEC_OF_MIN_TO_RUN_AT = RANDOM.nextInt(60);
    private static final int MILLI_OF_SEC_TO_RUN_AT = RANDOM.nextInt(1000);
    private final InstanceTopologyService topologyService;

    public InstanceTopologyJob(InstanceTopologyService topologyService, UpmScheduler scheduler) {
        super(scheduler);
        this.topologyService = (InstanceTopologyService)Preconditions.checkNotNull((Object)topologyService, (Object)"topologyService");
    }

    @Override
    public DateTime getStartTime() {
        DateTime now = new DateTime();
        DateTime dt = now.withTime(HOUR_OF_DAY_TO_RUN_AT, MIN_OF_HOUR_TO_RUN_AT, SEC_OF_MIN_TO_RUN_AT, MILLI_OF_SEC_TO_RUN_AT);
        return dt.isAfter((ReadableInstant)now) ? dt : dt.plusDays(1);
    }

    @Override
    public Option<Duration> getInterval() {
        return Option.some(Duration.standardDays((long)1L));
    }

    @Override
    public void executeInternal(UpmScheduler.RunMode runMode) throws Exception {
        this.topologyService.sendInstanceTopologyData();
    }
}

