/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.pac.AvailableAddonWithVersionBase;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/purchased/available")
public class PurchasedPluginCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final LocaleResolver localeResolver;
    private final PacClient pacClient;
    private final PluginRetriever pluginRetriever;
    private final PluginLicenseRepository licenseRepository;
    private final UpmAppManager appManager;
    private static final Function<AvailableAddonWithVersionBase, String> pluginSummaryToKey = new Function<AvailableAddonWithVersionBase, String>(){

        public String apply(AvailableAddonWithVersionBase a) {
            return a.getAddonBase().getKey();
        }
    };

    public PurchasedPluginCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, LocaleResolver localeResolver, PacClient pacClient, PluginRetriever pluginRetriever, PluginLicenseRepository licenseRepository, UpmAppManager appManager) {
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@Context HttpServletRequest request) {
        this.permissionEnforcer.enforcePermission(Permission.GET_PURCHASED_PLUGINS);
        Set<String> applicationPluginKeys = this.appManager.getApplicationRelatedPlugins(Iterables.transform(this.pluginRetriever.getPlugins(), Plugins.toPlugPlugin)).keySet();
        Predicate isApplicationPluginLicense = Predicates.compose((Predicate)Predicates.in(applicationPluginKeys), PluginLicenses.licensePluginKey());
        ImmutableList licenses = ImmutableList.copyOf((Iterable)Iterables.filter(this.licenseRepository.getPluginLicenses(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.not(PluginLicenses.isEvaluation()), Predicates.not(PluginLicenses.isEmbeddedWithinHostLicense()), Predicates.not((Predicate)isApplicationPluginLicense)})));
        ImmutableMap licenseMap = Maps.uniqueIndex((Iterable)licenses, PluginLicenses.licensePluginKey());
        boolean pacUnreachable = !this.pacClient.isPacReachable();
        ImmutableList plugins = ImmutableList.copyOf(this.pacClient.getPlugins(licenseMap.keySet()));
        Ordering ordering = this.orderingWithInstalledPluginsLast().compound(this.orderingByPluginName(this.localeResolver.getLocale(request)));
        ImmutableSet compatiblePluginKeysReturnedByMpac = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)plugins, pluginSummaryToKey));
        Sets.SetView incompatibleOrUnknownPluginKeys = Sets.difference(licenseMap.keySet(), (Set)compatiblePluginKeysReturnedByMpac);
        ImmutableList incompatiblePlugins = ImmutableList.copyOf(this.pacClient.getLatestVersionOfPlugins((Iterable<String>)incompatibleOrUnknownPluginKeys));
        ImmutableSet incompatiblePluginKeysReturnedByMpac = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)incompatiblePlugins, pluginSummaryToKey));
        Sets.SetView unknownPluginKeys = Sets.difference((Set)incompatibleOrUnknownPluginKeys, (Set)incompatiblePluginKeysReturnedByMpac);
        return Response.ok((Object)this.representationFactory.createPurchasedPluginCollectionRepresentation(this.localeResolver.getLocale(request), ordering.sortedCopy((Iterable)plugins), (Iterable<AvailableAddonWithVersionBase>)incompatiblePlugins, (Iterable<String>)unknownPluginKeys, new RequestContext(request).pacUnreachable(pacUnreachable))).build();
    }

    private Ordering<AvailableAddonWithVersionBase> orderingWithInstalledPluginsLast() {
        return new Ordering<AvailableAddonWithVersionBase>(){

            public int compare(AvailableAddonWithVersionBase a, AvailableAddonWithVersionBase b) {
                boolean bInstalled;
                boolean aInstalled = PurchasedPluginCollectionResource.this.pluginRetriever.isPluginInstalled(a.getAddonBase().getKey());
                if (aInstalled == (bInstalled = PurchasedPluginCollectionResource.this.pluginRetriever.isPluginInstalled(b.getAddonBase().getKey()))) {
                    return 0;
                }
                return aInstalled ? 1 : -1;
            }
        };
    }

    private Ordering<AvailableAddonWithVersionBase> orderingByPluginName(Locale locale) {
        final Collator collator = Collator.getInstance(locale);
        return new Ordering<AvailableAddonWithVersionBase>(){

            public int compare(AvailableAddonWithVersionBase a, AvailableAddonWithVersionBase b) {
                return collator.compare(a.getAddonBase().getName(), b.getAddonBase().getName());
            }
        };
    }
}

