/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.resources;

import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.jwt.UpmJwtToken;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.atlassian.upm.topology.InstanceTopology;
import com.atlassian.upm.topology.InstanceTopologyFactory;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@WebSudoNotRequired
@Path(value="/topology")
public class InstanceTopologyResource {
    private final InstanceTopologyFactory topologyFactory;
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    public InstanceTopologyResource(InstanceTopologyFactory topologyFactory, UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.topologyFactory = (InstanceTopologyFactory)Preconditions.checkNotNull((Object)topologyFactory, (Object)"topologyFactory");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response getTopology() {
        this.enforceTopologyPermission();
        Iterator<InstanceTopology> iterator = this.topologyFactory.generateTopology().iterator();
        if (iterator.hasNext()) {
            InstanceTopology topology = iterator.next();
            return Response.ok((Object)this.representationFactory.createInstanceTopologyRepresentation(topology)).build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @GET
    @Path(value="jwt")
    @Produces(value={"application/vnd.atl.plugins+json"})
    @WebSudoRequired
    public Response getJwtToken() {
        this.enforceTopologyPermission();
        Iterator<UpmJwtToken> iterator = this.topologyFactory.generateJwtToken().iterator();
        if (iterator.hasNext()) {
            UpmJwtToken token = iterator.next();
            return Response.ok((Object)this.representationFactory.createJwtTokenRepresentation(token)).build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    private void enforceTopologyPermission() {
        this.permissionEnforcer.enforcePermission(Permission.GET_INSTALLED_PLUGINS);
        this.permissionEnforcer.enforcePermission(Permission.GET_PLUGIN_LICENSE);
    }
}

