/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.representations;

import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonBase;
import com.atlassian.marketplace.client.model.AddonReference;
import com.atlassian.marketplace.client.model.AddonSummary;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.marketplace.client.model.AddonVersionBase;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.model.ConnectScope;
import com.atlassian.marketplace.client.model.VendorSummary;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.MarketplacePlugins;
import com.atlassian.upm.PluginInfoUtils;
import com.atlassian.upm.PluginPrimaryAction;
import com.atlassian.upm.PluginUpdateRequestStore;
import com.atlassian.upm.ProductUpdatePluginCompatibility;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRestartRequiredService;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.SafeModeAccessor;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.async.AsynchronousTaskManager;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.representations.DefaultRepresentationFactory;
import com.atlassian.upm.core.rest.representations.LinksMapBuilder;
import com.atlassian.upm.core.rest.representations.VendorRepresentation;
import com.atlassian.upm.core.rest.resources.RequestContext;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.jwt.UpmJwtToken;
import com.atlassian.upm.license.LicensedPlugins;
import com.atlassian.upm.license.internal.HostLicenseProvider;
import com.atlassian.upm.license.internal.LicenseDateFormatter;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensingPluginService;
import com.atlassian.upm.osgi.Bundle;
import com.atlassian.upm.osgi.BundleAccessor;
import com.atlassian.upm.osgi.Package;
import com.atlassian.upm.osgi.PackageAccessor;
import com.atlassian.upm.osgi.Service;
import com.atlassian.upm.osgi.ServiceAccessor;
import com.atlassian.upm.osgi.rest.representations.BundleRepresentation;
import com.atlassian.upm.osgi.rest.representations.BundleSummaryRepresentation;
import com.atlassian.upm.osgi.rest.representations.CollectionRepresentation;
import com.atlassian.upm.osgi.rest.representations.PackageRepresentation;
import com.atlassian.upm.osgi.rest.representations.PackageSummaryRepresentation;
import com.atlassian.upm.osgi.rest.representations.ServiceRepresentation;
import com.atlassian.upm.osgi.rest.representations.ServiceSummaryRepresentation;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.pac.AvailableAddonWithVersionBase;
import com.atlassian.upm.pac.IncompatiblePluginData;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.pac.PluginVersionPair;
import com.atlassian.upm.request.PluginRequest;
import com.atlassian.upm.request.PluginRequestStore;
import com.atlassian.upm.request.rest.representations.PluginRequestCollectionRepresentation;
import com.atlassian.upm.request.rest.representations.PluginRequestRepresentation;
import com.atlassian.upm.rest.UpmMarketplaceFilter;
import com.atlassian.upm.rest.UpmUriBuilder;
import com.atlassian.upm.rest.representations.AvailablePluginCollectionRepresentation;
import com.atlassian.upm.rest.representations.AvailablePluginRepresentation;
import com.atlassian.upm.rest.representations.BannerCollectionRepresentation;
import com.atlassian.upm.rest.representations.HostLicenseDetailsRepresentation;
import com.atlassian.upm.rest.representations.HostStatusRepresentation;
import com.atlassian.upm.rest.representations.InstalledMarketplacePluginCollectionRepresentation;
import com.atlassian.upm.rest.representations.InstalledMarketplacePluginRepresentation;
import com.atlassian.upm.rest.representations.InstanceTopologyRepresentation;
import com.atlassian.upm.rest.representations.JwtTokenRepresentation;
import com.atlassian.upm.rest.representations.PacDetailsRepresentation;
import com.atlassian.upm.rest.representations.PluginLicenseRepresentation;
import com.atlassian.upm.rest.representations.PluginPermissionRepresentation;
import com.atlassian.upm.rest.representations.ProductUpdatePluginCompatibilityRepresentation;
import com.atlassian.upm.rest.representations.ProductUpdatesRepresentation;
import com.atlassian.upm.rest.representations.ProductVersionRepresentation;
import com.atlassian.upm.rest.representations.PurchasedPluginCollectionRepresentation;
import com.atlassian.upm.rest.representations.RecommendedPluginCollectionRepresentation;
import com.atlassian.upm.rest.representations.SafeModeErrorReenablingPluginModuleRepresentation;
import com.atlassian.upm.rest.representations.SafeModeErrorReenablingPluginRepresentation;
import com.atlassian.upm.rest.representations.UpmLinkBuilder;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.atlassian.upm.rest.representations.UpmSettingsCollectionRepresentation;
import com.atlassian.upm.rest.representations.UserSettingsRepresentation;
import com.atlassian.upm.rest.resources.PacStatusResource;
import com.atlassian.upm.topology.InstanceTopology;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UpmRepresentationFactoryImpl
extends DefaultRepresentationFactory
implements UpmRepresentationFactory {
    private final PluginRetriever pluginRetriever;
    private final UpmUriBuilder uriBuilder;
    private final UpmLinkBuilder linkBuilder;
    private final AsynchronousTaskManager taskManager;
    private final BundleAccessor bundleAccessor;
    private final ServiceAccessor serviceAccessor;
    private final PackageAccessor packageAccessor;
    private final PermissionEnforcer permissionEnforcer;
    private final ApplicationProperties applicationProperties;
    private final LicenseDateFormatter licenseDateFormatter;
    private final HostLicenseProvider hostLicenseProvider;
    private final PacClient pacClient;
    private final PluginLicenseRepository licenseRepository;
    private final SysPersisted sysPersisted;
    private final UserManager userManager;
    private final PluginRequestStore pluginRequestStore;
    private final HostLicenseInformation hostLicenseInformation;
    private final UpmInformation upm;
    private final PluginUpdateRequestStore pluginUpdateRequestStore;
    private final SafeModeAccessor safeMode;
    private final I18nResolver i18nResolver;
    private final RoleBasedLicensingPluginService roleBasedLicensingPluginService;
    private final UpmHostApplicationInformation appInfo;
    private final HostApplicationDescriptor hostApplicationDescriptor;
    private Function<PluginRequest, PluginRequestRepresentation> toPluginRequestRepresentation = new Function<PluginRequest, PluginRequestRepresentation>(){

        public PluginRequestRepresentation apply(PluginRequest pluginRequest) {
            return UpmRepresentationFactoryImpl.this.createPluginRequestRepresentation(pluginRequest);
        }
    };
    private Function<Pair<AvailableAddonWithVersion, Iterable<PluginRequest>>, AvailablePluginCollectionRepresentation.RequestedPluginEntry> toRequestedPluginEntry = new Function<Pair<AvailableAddonWithVersion, Iterable<PluginRequest>>, AvailablePluginCollectionRepresentation.RequestedPluginEntry>(){

        public AvailablePluginCollectionRepresentation.RequestedPluginEntry apply(Pair<AvailableAddonWithVersion, Iterable<PluginRequest>> input) {
            return UpmRepresentationFactoryImpl.this.createRequestedPluginEntry(input.first().getAddon(), input.first().getVersion(), input.second());
        }
    };
    private final Function<PluginRequestRepresentation, PluginRequestRepresentation> stripOtherUserInfo = new Function<PluginRequestRepresentation, PluginRequestRepresentation>(){

        public PluginRequestRepresentation apply(PluginRequestRepresentation rep) {
            if (rep.getUser().getUserKey().equals(UpmRepresentationFactoryImpl.this.userManager.getRemoteUserKey().getStringValue())) {
                return rep;
            }
            return PluginRequestRepresentation.anonymize(rep);
        }
    };

    public UpmRepresentationFactoryImpl(PluginRetriever pluginRetriever, PluginMetadataAccessor metadata, UpmUriBuilder uriBuilder, UpmLinkBuilder linkBuilder, PacClient pacClient, AsynchronousTaskManager taskManager, BundleAccessor bundleAccessor, ServiceAccessor serviceAccessor, PackageAccessor packageAccessor, PermissionEnforcer permissionEnforcer, ApplicationProperties applicationProperties, LicenseDateFormatter licenseDateFormatter, HostLicenseProvider hostLicenseProvider, PluginLicenseRepository licenseRepository, SysPersisted sysPersisted, UserManager userManager, PluginRequestStore pluginRequestStore, HostLicenseInformation hostLicenseInformation, UpmInformation upm, PluginUpdateRequestStore pluginUpdateRequestStore, SafeModeAccessor safeMode, PluginRestartRequiredService restartRequiredService, I18nResolver i18nResolver, RoleBasedLicensingPluginService roleBasedLicensingPluginService, UpmHostApplicationInformation appInfo, HostApplicationDescriptor hostApplicationDescriptor, UpmAppManager appManager) {
        super(pluginRetriever, metadata, uriBuilder, linkBuilder, permissionEnforcer, restartRequiredService, appManager);
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.uriBuilder = (UpmUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.linkBuilder = (UpmLinkBuilder)Preconditions.checkNotNull((Object)linkBuilder, (Object)"linkBuilder");
        this.taskManager = (AsynchronousTaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager");
        this.bundleAccessor = (BundleAccessor)Preconditions.checkNotNull((Object)bundleAccessor, (Object)"bundleAccessor");
        this.serviceAccessor = (ServiceAccessor)Preconditions.checkNotNull((Object)serviceAccessor, (Object)"serviceAccessor");
        this.packageAccessor = (PackageAccessor)Preconditions.checkNotNull((Object)packageAccessor, (Object)"packageAccessor");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.licenseDateFormatter = (LicenseDateFormatter)Preconditions.checkNotNull((Object)licenseDateFormatter, (Object)"licenseDateFormatter");
        this.hostLicenseProvider = (HostLicenseProvider)Preconditions.checkNotNull((Object)hostLicenseProvider, (Object)"hostLicenseProvider");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.pluginRequestStore = (PluginRequestStore)Preconditions.checkNotNull((Object)pluginRequestStore, (Object)"pluginRequestStore");
        this.hostLicenseInformation = (HostLicenseInformation)Preconditions.checkNotNull((Object)hostLicenseInformation, (Object)"hostLicenseInformation");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
        this.pluginUpdateRequestStore = (PluginUpdateRequestStore)Preconditions.checkNotNull((Object)pluginUpdateRequestStore, (Object)"pluginUpdateRequestStore");
        this.safeMode = (SafeModeAccessor)Preconditions.checkNotNull((Object)safeMode, (Object)"safeMode");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.roleBasedLicensingPluginService = (RoleBasedLicensingPluginService)Preconditions.checkNotNull((Object)roleBasedLicensingPluginService, (Object)"roleBasedLicensingPluginService");
        this.appInfo = (UpmHostApplicationInformation)Preconditions.checkNotNull((Object)appInfo, (Object)"appInfo");
        this.hostApplicationDescriptor = (HostApplicationDescriptor)Preconditions.checkNotNull((Object)hostApplicationDescriptor, (Object)"hostApplicationDescriptor");
    }

    @Override
    public InstalledMarketplacePluginCollectionRepresentation createInstalledMarketplacePluginCollectionRepresentation(Locale locale, Iterable<Plugin> plugins, Iterable<AvailableAddonWithVersion> updates, Iterable<IncompatiblePluginData> incompatibles, RequestContext context, String upmUpdateVersion) {
        return new InstalledMarketplacePluginCollectionRepresentation(this, this.uriBuilder, this.linkBuilder, this.appInfo, locale, plugins, updates, incompatibles, this.createHostStatusRepresentation(context), upmUpdateVersion);
    }

    @Override
    public InstalledMarketplacePluginRepresentation createInstalledMarketplacePluginRepresentation(Plugin plugin, Option<AvailableAddonWithVersion> availableUpdate, Option<IncompatiblePluginData> incompatible) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        boolean usesLicensing = this.isInstalledPluginUsingLicensing(plugin);
        Option<PluginLicense> license = this.getPluginLicense(plugin, usesLicensing);
        PluginLicenseRepresentation licenseDetails = this.getLicenseDetailsRepresentation(plugin, license, usesLicensing);
        Option<AddonVersion> availableUpdateVersion = availableUpdate.map(AvailableAddonWithVersion::getVersion);
        boolean updatableToPaid = this.permissionEnforcer.hasPermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI) && com.atlassian.upm.license.impl.LicensedPlugins.isFreeUpdatableToPaid(plugin, availableUpdateVersion, this.appManager);
        Optional<PluginPrimaryAction> actionRequired = com.atlassian.upm.license.impl.LicensedPlugins.getPrimaryPluginActionRequired(this.permissionEnforcer, this.pluginUpdateRequestStore, this.roleBasedLicensingPluginService, plugin, availableUpdateVersion, incompatible, license, this.appManager, this.appInfo);
        InstalledMarketplacePluginRepresentation.PluginPrimaryActionRepresentation primaryAction = actionRequired.map(pluginPrimaryAction -> new InstalledMarketplacePluginRepresentation.PluginPrimaryActionRepresentation((PluginPrimaryAction)((Object)pluginPrimaryAction), plugin, this.permissionEnforcer, this.licenseRepository, this.pluginUpdateRequestStore)).orElse(null);
        boolean licenseReadOnly = usesLicensing && !this.permissionEnforcer.hasPermission(Permission.MANAGE_PLUGIN_LICENSE);
        LinksMapBuilder linksBuilder = this.linkBuilder.buildLinksForInstalledMarketplacePlugin(plugin, license, usesLicensing);
        PacDetailsRepresentation.AvailablePluginUpdateRepresentation updateRep = null;
        for (AvailableAddonWithVersion update : availableUpdate) {
            linksBuilder.putIfPermitted(Permission.GET_AVAILABLE_PLUGINS, Option.some(plugin), "update-details", this.uriBuilder.buildAvailablePluginUri(plugin.getKey()));
            for (URI binary : update.getVersion().getArtifactUri()) {
                linksBuilder.putIfPermitted(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI, Option.some(plugin), "binary", binary);
            }
            updateRep = new PacDetailsRepresentation.AvailablePluginUpdateRepresentation(update, plugin, this.uriBuilder, this.linkBuilder, this.upm, this.licenseRepository, this.applicationProperties, this.permissionEnforcer, this.appManager, this.hostLicenseInformation, this.licenseDateFormatter);
        }
        actionRequired.ifPresent(pluginPrimaryAction -> {
            if (pluginPrimaryAction.canRequestUpdateFromVendor() && primaryAction.isActionRequired()) {
                linksBuilder.putIfPermitted(Permission.REQUEST_PLUGIN_UPDATE, Option.some(plugin), "request-update", this.uriBuilder.buildRequestUpdateUri(plugin.getKey()));
            }
        });
        return new InstalledMarketplacePluginRepresentation((Map<String, URI>)linksBuilder.build(), plugin.getKey(), plugin.getName(), licenseDetails, licenseReadOnly, primaryAction, plugin.getKey(), updatableToPaid, incompatible.isDefined(), !MarketplacePlugins.isLegacyDataCenterIncompatible(plugin, this.appInfo), !MarketplacePlugins.isDataCenterIncompatible(plugin, this.appInfo), updateRep, PluginInfoUtils.isDataCenterApp(plugin.getPluginInformation()));
    }

    private boolean isInstalledPluginUsingLicensing(Plugin plugin) {
        return LicensedPlugins.usesLicensing(plugin.getPlugin(), this.appManager) && this.permissionEnforcer.hasPermission(Permission.MANAGE_PLUGIN_LICENSE, plugin);
    }

    private Option<PluginLicense> getPluginLicense(Plugin plugin, boolean usesLicensing) {
        return usesLicensing ? this.licenseRepository.getPluginLicense(plugin.getKey()) : Option.none(PluginLicense.class);
    }

    private PluginLicenseRepresentation getLicenseDetailsRepresentation(Plugin plugin, Option<PluginLicense> license, boolean usesLicensing) {
        if (usesLicensing && license.isDefined()) {
            return this.createPluginLicenseRepresentation(plugin.getKey(), Option.some(plugin), license);
        }
        return null;
    }

    @Override
    public PacDetailsRepresentation createPacDetailsRepresentation(Plugin plugin, Option<PluginVersionPair> pluginVersionPair) {
        return new PacDetailsRepresentation(pluginVersionPair, plugin, this.uriBuilder, this.linkBuilder, this.permissionEnforcer, this.licenseRepository, this.applicationProperties, this.upm, this.appManager, this.hostLicenseInformation, this.licenseDateFormatter);
    }

    @Override
    public AvailablePluginCollectionRepresentation.AvailablePluginEntry createAvailablePluginEntry(AddonBase plugin, AddonVersionBase version) {
        Option<Plugin> installedPlugin = this.pluginRetriever.getPlugin(plugin.getKey());
        return new AvailablePluginCollectionRepresentation.AvailablePluginEntry(installedPlugin, this.applicationProperties, plugin, version, this.uriBuilder, this.linkBuilder, this.permissionEnforcer, this.licenseRepository, this, this.hostApplicationDescriptor);
    }

    @Override
    public AvailablePluginCollectionRepresentation.RequestedPluginEntry createRequestedPluginEntry(AddonBase plugin, AddonVersionBase version, Iterable<PluginRequest> requests) {
        Option<Plugin> installedPlugin = this.pluginRetriever.getPlugin(plugin.getKey());
        Iterable requestReps = Iterables.transform(requests, this.toPluginRequestRepresentation);
        return new AvailablePluginCollectionRepresentation.RequestedPluginEntry(installedPlugin, this.applicationProperties, plugin, version, this.uriBuilder, this.linkBuilder, this.permissionEnforcer, this.licenseRepository, this, requestReps, this.hostApplicationDescriptor);
    }

    @Override
    public PurchasedPluginCollectionRepresentation.UnknownPluginEntry createUnknownPluginEntry(String pluginKey) {
        Iterator<Plugin> iterator = this.pluginRetriever.getPlugin(pluginKey).iterator();
        if (iterator.hasNext()) {
            Plugin plugin = iterator.next();
            LinksMapBuilder builder = this.linkBuilder.buildLinkForSelf(this.uriBuilder.buildPluginUri(plugin.getKey())).putIfPermitted(Permission.GET_AVAILABLE_PLUGINS, "plugin-details", this.uriBuilder.buildUpmTabPluginUri("manage", pluginKey));
            return new PurchasedPluginCollectionRepresentation.UnknownPluginEntry(pluginKey, plugin.getName(), (Map<String, URI>)builder.build());
        }
        return new PurchasedPluginCollectionRepresentation.UnknownPluginEntry(pluginKey, null, (Map<String, URI>)ImmutableMap.of());
    }

    @Override
    public AvailablePluginCollectionRepresentation createAvailablePluginCollectionRepresentation(Iterable<AvailableAddonWithVersionBase> addons, Page<AddonSummary> sourceAddons, Map<String, PluginRequest> pluginRequests, RequestContext context, final UpmMarketplaceFilter filter, final Option<String> searchText) {
        return new AvailablePluginCollectionRepresentation(this.linkBuilder, addons, sourceAddons, pluginRequests, this.createHostStatusRepresentation(context), this, (Function<? super Integer, URI>)new Function<Integer, URI>(){

            public URI apply(Integer offset) {
                return UpmRepresentationFactoryImpl.this.uriBuilder.buildAvailablePluginCollectionUri(filter, searchText, offset);
            }
        });
    }

    @Override
    public AvailablePluginRepresentation createAvailablePluginRepresentation(Addon addon, AddonVersion version) {
        return new AvailablePluginRepresentation((Addon)Preconditions.checkNotNull((Object)addon, (Object)"addon"), (AddonVersion)Preconditions.checkNotNull((Object)version, (Object)"addonVersion"), this.uriBuilder, this.linkBuilder, this.pluginRetriever, this.applicationProperties, this.permissionEnforcer, this, this.pluginRequestStore, this.licenseRepository, this.upm, this.hostApplicationDescriptor, this.appManager);
    }

    @Override
    public BannerCollectionRepresentation createBannerCollectionRepresentation(Page<AddonReference> banners) {
        return new BannerCollectionRepresentation(banners, this.uriBuilder, this.linkBuilder);
    }

    @Override
    public RecommendedPluginCollectionRepresentation createRecommendedPluginCollectionRepresentation(Iterable<AddonReference> recommendations, String pluginKey) {
        return new RecommendedPluginCollectionRepresentation(recommendations, this.uriBuilder, this.linkBuilder, pluginKey);
    }

    @Override
    public ProductUpdatesRepresentation createProductUpdatesRepresentation(Iterable<ApplicationVersion> productVersions, RequestContext context) {
        return new ProductUpdatesRepresentation(this.uriBuilder, productVersions, this.linkBuilder, this.createHostStatusRepresentation(context));
    }

    @Override
    public ProductVersionRepresentation createProductVersionRepresentation(boolean development, boolean unknown) {
        return new ProductVersionRepresentation(development, unknown);
    }

    @Override
    public ProductUpdatePluginCompatibilityRepresentation createProductUpdatePluginCompatibilityRepresentation(ProductUpdatePluginCompatibility pluginCompatibility, int productUpdateBuildNumber, Locale locale) {
        return new ProductUpdatePluginCompatibilityRepresentation(this.uriBuilder, this.linkBuilder, this.pluginRetriever, pluginCompatibility, productUpdateBuildNumber, locale);
    }

    @Override
    public CollectionRepresentation<BundleSummaryRepresentation> createOsgiBundleCollectionRepresentation() {
        return this.createOsgiBundleCollectionRepresentation(null);
    }

    @Override
    public CollectionRepresentation<BundleSummaryRepresentation> createOsgiBundleCollectionRepresentation(@Nullable String term) {
        return new CollectionRepresentation<BundleSummaryRepresentation>(BundleSummaryRepresentation.wrapSummary(this.uriBuilder).fromIterable(this.bundleAccessor.getBundles(term)), this.safeMode.isSafeMode(), (Map<String, URI>)this.linkBuilder.buildLinksFor(this.uriBuilder.buildOsgiBundleCollectionUri(term)).build());
    }

    @Override
    public BundleRepresentation createOsgiBundleRepresentation(Bundle bundle) {
        return new BundleRepresentation((Bundle)Preconditions.checkNotNull((Object)bundle, (Object)"bundle"), this.uriBuilder);
    }

    @Override
    public CollectionRepresentation<ServiceSummaryRepresentation> createOsgiServiceCollectionRepresentation() {
        return new CollectionRepresentation<ServiceSummaryRepresentation>(ServiceSummaryRepresentation.wrapSummary(this.uriBuilder).fromIterable(this.serviceAccessor.getServices()), this.safeMode.isSafeMode(), (Map<String, URI>)this.linkBuilder.buildLinksFor(this.uriBuilder.buildOsgiServiceCollectionUri()).build());
    }

    @Override
    public ServiceRepresentation createOsgiServiceRepresentation(Service service) {
        return new ServiceRepresentation((Service)Preconditions.checkNotNull((Object)service, (Object)"service"), this.uriBuilder);
    }

    @Override
    public CollectionRepresentation<PackageSummaryRepresentation> createOsgiPackageCollectionRepresentation() {
        return new CollectionRepresentation<PackageSummaryRepresentation>(PackageSummaryRepresentation.wrapSummary(this.uriBuilder).fromIterable(this.packageAccessor.getPackages()), this.safeMode.isSafeMode(), (Map<String, URI>)this.linkBuilder.buildLinksFor(this.uriBuilder.buildOsgiPackageCollectionUri()).build());
    }

    @Override
    public PackageRepresentation createOsgiPackageRepresentation(Package pkg) {
        return new PackageRepresentation((Package)Preconditions.checkNotNull((Object)pkg, (Object)"pkg"), this.uriBuilder);
    }

    @Override
    public PacStatusResource.PacStatusRepresentation createPacStatusRepresentation(boolean disabled, boolean reached) {
        return new PacStatusResource.PacStatusRepresentation(disabled, reached, this.uriBuilder, this.linkBuilder);
    }

    @Override
    public PluginLicenseRepresentation createPluginLicenseRepresentation(String pluginKey, Option<Plugin> plugin, Option<PluginLicense> pluginLicense) {
        Iterator<PluginLicense> iterator = pluginLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense license = iterator.next();
            return new PluginLicenseRepresentation(pluginKey, plugin, license, this.licenseDateFormatter, this.linkBuilder, this.roleBasedLicensingPluginService, this.i18nResolver, this.hostLicenseInformation);
        }
        return new PluginLicenseRepresentation(pluginKey, plugin, this.linkBuilder);
    }

    @Override
    public HostStatusRepresentation createHostStatusRepresentation(RequestContext context) {
        return new HostStatusRepresentation(!this.taskManager.isBaseUrlValid(context.getRequest()), this.safeMode.isSafeMode(), this.sysPersisted.is(UpmSettings.PAC_DISABLED), context.isPacUnreachable(), this.createHostLicenseRepresentation());
    }

    @Override
    public HostLicenseDetailsRepresentation createHostLicenseRepresentation() {
        return new HostLicenseDetailsRepresentation(this.hostLicenseProvider.getHostApplicationLicenseAttributes(), this.appInfo, this.licenseDateFormatter);
    }

    @Override
    public PluginRequestRepresentation createPluginRequestRepresentation(PluginRequest request) {
        return new PluginRequestRepresentation(request.getPluginKey(), request, this.linkBuilder, this.uriBuilder);
    }

    @Override
    public PluginRequestCollectionRepresentation createPluginRequestCollectionRepresentation(Map<String, Iterable<PluginRequest>> requests) {
        return this.createPluginRequestCollectionRepresentation(requests, false);
    }

    @Override
    public PluginRequestCollectionRepresentation createAnonymousPluginRequestCollectionRepresentation(Map<String, Iterable<PluginRequest>> requests) {
        return this.createPluginRequestCollectionRepresentation(requests, true);
    }

    @Override
    public PurchasedPluginCollectionRepresentation createPurchasedPluginCollectionRepresentation(Locale locale, Iterable<AvailableAddonWithVersionBase> plugins, Iterable<AvailableAddonWithVersionBase> incompatiblePlugins, Iterable<String> unknownPluginKeys, RequestContext context) {
        return new PurchasedPluginCollectionRepresentation(plugins, incompatiblePlugins, unknownPluginKeys, this.uriBuilder, this.linkBuilder, this.createHostStatusRepresentation(context), this);
    }

    @Override
    public UpmSettingsCollectionRepresentation createUpmSettingsCollectionRepresentation() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (UpmSettings s : UpmSettings.values()) {
            if (!this.permissionEnforcer.hasPermission(s.getPermission())) continue;
            builder.add((Object)new UpmSettingsCollectionRepresentation.UpmSettingRepresentation(s.getKey(), this.sysPersisted.is(s), s.isRequiresRefresh(), s.getDefaultCheckedValue(), false));
        }
        return new UpmSettingsCollectionRepresentation((Collection<UpmSettingsCollectionRepresentation.UpmSettingRepresentation>)builder.build());
    }

    @Override
    public UserSettingsRepresentation createUserSettingsRepresentation(boolean emailDisabled) {
        return new UserSettingsRepresentation(emailDisabled);
    }

    @Override
    public VendorRepresentation createVendorRepresentation(VendorSummary vendor) {
        if (vendor == null || StringUtils.isBlank((CharSequence)vendor.getName())) {
            return null;
        }
        URI marketplaceLink = URI.create(Sys.getMpacBaseUrl()).resolve(vendor.getAlternateUri());
        return new VendorRepresentation(vendor.getName(), marketplaceLink, vendor.isTopVendor());
    }

    @Override
    public SafeModeErrorReenablingPluginRepresentation createSafeModeErrorReenablingPluginRepresentation(Plugin plugin, boolean enabling) {
        return new SafeModeErrorReenablingPluginRepresentation(plugin.getKey(), plugin.getName(), enabling);
    }

    @Override
    public SafeModeErrorReenablingPluginModuleRepresentation createSafeModeErrorReenablingPluginModuleRepresentation(Plugin.Module module, boolean enabling) {
        return new SafeModeErrorReenablingPluginModuleRepresentation(module.getPlugin().getKey(), module.getPlugin().getName(), module.getCompleteKey(), module.getName(), enabling);
    }

    @Override
    public PluginPermissionRepresentation createPluginPermissionRepresentation(ConnectScope scope) {
        String nameKey = "connect.scope." + scope.getKey().toLowerCase() + ".name";
        String descriptionKey = "connect.scope." + scope.getKey().toLowerCase() + ".description";
        return new PluginPermissionRepresentation(scope.getKey(), this.getI18nOrDefaultValue(nameKey, scope.getName()), this.getI18nOrDefaultValue(descriptionKey, scope.getDescription()));
    }

    private String getI18nOrDefaultValue(String i18nKey, String defaultValue) {
        String val = this.i18nResolver.getText(i18nKey, new Serializable[]{this.applicationProperties.getDisplayName()});
        return i18nKey.equals(val) ? defaultValue : val;
    }

    private PluginRequestCollectionRepresentation createPluginRequestCollectionRepresentation(Map<String, Iterable<PluginRequest>> requests, boolean anonymize) {
        Iterable<AvailableAddonWithVersion> plugins = this.pacClient.getPlugins(requests.keySet());
        ImmutableList.Builder pluginsWithRequests = ImmutableList.builder();
        for (AvailableAddonWithVersion a : plugins) {
            String pluginKey = a.getAddon().getKey();
            if (!requests.containsKey(pluginKey)) continue;
            pluginsWithRequests.add(Pair.pair(a, requests.get(pluginKey)));
        }
        Iterable<AvailablePluginCollectionRepresentation.RequestedPluginEntry> requestedPlugins = Iterables.transform((Iterable)pluginsWithRequests.build(), this.toRequestedPluginEntry);
        if (anonymize) {
            requestedPlugins = this.anonymize(requestedPlugins);
        }
        return new PluginRequestCollectionRepresentation((Map<String, URI>)this.linkBuilder.buildLinksFor(this.uriBuilder.buildPluginRequestCollectionResourceUri()).build(), Ordering.natural().sortedCopy(requestedPlugins));
    }

    private Iterable<AvailablePluginCollectionRepresentation.RequestedPluginEntry> anonymize(Iterable<AvailablePluginCollectionRepresentation.RequestedPluginEntry> nonAnonymous) {
        return Iterables.transform(nonAnonymous, (Function)new Function<AvailablePluginCollectionRepresentation.RequestedPluginEntry, AvailablePluginCollectionRepresentation.RequestedPluginEntry>(){

            public AvailablePluginCollectionRepresentation.RequestedPluginEntry apply(AvailablePluginCollectionRepresentation.RequestedPluginEntry entry) {
                return new AvailablePluginCollectionRepresentation.RequestedPluginEntry(entry, Iterables.transform(entry.getRequests(), (Function)UpmRepresentationFactoryImpl.this.stripOtherUserInfo));
            }
        });
    }

    private InstanceTopologyRepresentation.InstanceTopologyProductLicenseRepresentation createLicenseProductRepresentation(InstanceTopology.InstanceTopologyLicense license) {
        return new InstanceTopologyRepresentation.InstanceTopologyProductLicenseRepresentation(license.getSen(), license.isEval(), license.getLicenseType().getKey(), license.getEditionType().getKey(), license.isDataCenter(), license.getLicensedUsers(), license.getPurchaseDate().getMillis());
    }

    private InstanceTopologyRepresentation.InstanceTopologyAddonLicenseRepresentation createLicenseAddonRepresentation(InstanceTopology.InstanceTopologyAddon addon) {
        InstanceTopology.InstanceTopologyLicense license = addon.getLicense();
        String error = addon.getError().map(new Function<LicenseError, String>(){

            public String apply(LicenseError error) {
                return error.name().toLowerCase();
            }
        }).getOrElse((String)null);
        return new InstanceTopologyRepresentation.InstanceTopologyAddonLicenseRepresentation(license.getSen(), license.isEval(), license.getLicenseType().getKey(), license.getEditionType().getKey(), license.isDataCenter(), license.getLicensedUsers(), addon.isValid(), error, license.getPurchaseDate().getMillis());
    }

    @Override
    public InstanceTopologyRepresentation createInstanceTopologyRepresentation(InstanceTopology topology) {
        InstanceTopology.InstanceTopologyLicense license;
        ImmutableList.Builder addons = ImmutableList.builder();
        ImmutableList.Builder products = ImmutableList.builder();
        for (InstanceTopology.InstanceTopologyProduct product : topology.getProductLicenses()) {
            license = product.getLicense();
            products.add((Object)new InstanceTopologyRepresentation.InstanceTopologyProductRepresentation(this.createLicenseProductRepresentation(product.getLicense()), license.getKey(), license.getName(), license.isInstalled(), license.getVersion().getOrElse((String)null), license.getActiveUsers()));
        }
        for (InstanceTopology.InstanceTopologyAddon addon : topology.getAddonLicenses()) {
            license = addon.getLicense();
            addons.add((Object)new InstanceTopologyRepresentation.InstanceTopologyAddonRepresentation(this.createLicenseAddonRepresentation(addon), license.getKey(), license.getName(), license.isInstalled(), license.getVersion().getOrElse((String)null), license.getActiveUsers()));
        }
        InstanceTopologyRepresentation.Cloud cloud = null;
        for (String host : topology.getCloud()) {
            cloud = new InstanceTopologyRepresentation.Cloud(host);
        }
        return new InstanceTopologyRepresentation(topology.getServerId(), topology.getInstanceUrl().toASCIIString(), topology.getInstanceName(), cloud, topology.getPlatformVersion(), topology.getClient(), topology.getClientVersion(), (Collection<InstanceTopologyRepresentation.InstanceTopologyAddonRepresentation>)addons.build(), (Collection<InstanceTopologyRepresentation.InstanceTopologyProductRepresentation>)products.build(), topology.getTotalActiveUsers(), topology.getTotalLicensedUsers());
    }

    @Override
    public JwtTokenRepresentation createJwtTokenRepresentation(UpmJwtToken token) {
        return new JwtTokenRepresentation(token.getToken());
    }
}

