/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.rest.monitor.representations;

import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.permission.PermissionService;
import com.atlassian.upm.core.permission.UserAttributes;
import com.atlassian.upm.rest.monitor.representations.MonitorRepresentationFactory;
import com.atlassian.upm.rest.monitor.representations.PluginStateCollectionRep;
import com.atlassian.upm.rest.monitor.representations.PluginStateRep;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class MonitorRepresentationFactoryImpl
implements MonitorRepresentationFactory {
    private final PermissionService permissionService;

    public MonitorRepresentationFactoryImpl(PermissionService permissionService) {
        this.permissionService = (PermissionService)Preconditions.checkNotNull((Object)permissionService, (Object)"permissionService");
    }

    @Override
    public PluginStateRep createPluginStateRep(Plugin plugin) {
        boolean adminCanDisable = !this.permissionService.getPermissionError(UserAttributes.ADMIN_USER, Permission.MANAGE_PLUGIN_ENABLEMENT, plugin).isDefined();
        return new PluginStateRep(plugin.getKey(), plugin.getName(), plugin.getVersion(), plugin.isEnabled(), adminCanDisable, plugin.isConnect());
    }

    @Override
    public PluginStateCollectionRep createPluginStateCollectionRep(Iterable<Plugin> plugins) {
        return new PluginStateCollectionRep((Collection<PluginStateRep>)ImmutableList.copyOf((Iterable)Iterables.transform(plugins, (Function)new Function<Plugin, PluginStateRep>(){

            public PluginStateRep apply(Plugin p) {
                return MonitorRepresentationFactoryImpl.this.createPluginStateRep(p);
            }
        })));
    }
}

