/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.rest.resources;

import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.rest.representations.UpmRepresentationFactory;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/bundles")
public class BundleCollectionResource {
    private final UpmRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;

    public BundleCollectionResource(UpmRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.representationFactory = (UpmRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
    }

    @GET
    public Response get(@QueryParam(value="q") String term) {
        this.permissionEnforcer.enforcePermission(Permission.GET_OSGI_STATE);
        return Response.ok(term == null ? this.representationFactory.createOsgiBundleCollectionRepresentation() : this.representationFactory.createOsgiBundleCollectionRepresentation(term)).type("application/vnd.atl.plugins.osgi.bundles+json").build();
    }
}

