/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.upm.MarketplacePlugins;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmInformation;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Either;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginDownloadService;
import com.atlassian.upm.core.PluginInstallationService;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.SafeModeAccessor;
import com.atlassian.upm.core.SelfUpdateController;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.log.AuditLogService;
import com.atlassian.upm.license.LicensedAttributes;
import com.atlassian.upm.license.PluginLicenses;
import com.atlassian.upm.license.impl.LicensedPlugins;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.notification.ManualUpdateRequiredNotificationService;
import com.atlassian.upm.notification.NotificationCache;
import com.atlassian.upm.notification.NotificationType;
import com.atlassian.upm.notification.PluginUpdateChecker;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.pac.PacClient;
import com.atlassian.upm.schedule.UpmScheduler;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpdateCheckerImpl
implements PluginUpdateChecker {
    private static final Logger log = LoggerFactory.getLogger(PluginUpdateCheckerImpl.class);
    private final AuditLogService auditLogService;
    private final NotificationCache cache;
    private final PacClient pacClient;
    private final PluginRetriever pluginRetriever;
    private final PluginDownloadService downloadService;
    private final PluginInstallationService pluginInstaller;
    private final PluginLicenseRepository licenseRepository;
    private final SelfUpdateController selfUpdateController;
    private final SysPersisted sysPersisted;
    private final UpmScheduler scheduler;
    private final UpmInformation upm;
    private final SafeModeAccessor safeMode;
    private final ManualUpdateRequiredNotificationService manualUpdateNotificationService;
    private final UpmAppManager appManager;
    private final HostLicenseInformation hostLicenseInformation;

    public PluginUpdateCheckerImpl(AuditLogService auditLogService, NotificationCache cache, PacClient pacClient, PluginRetriever pluginRetriever, PluginDownloadService downloadService, PluginInstallationService pluginInstaller, PluginLicenseRepository licenseRepository, SelfUpdateController selfUpdateController, SysPersisted sysPersisted, UpmScheduler scheduler, UpmInformation upm, SafeModeAccessor safeMode, ManualUpdateRequiredNotificationService manualUpdateNotificationService, UpmAppManager appManager, HostLicenseInformation hostLicenseInformation) {
        this.auditLogService = (AuditLogService)Preconditions.checkNotNull((Object)auditLogService, (Object)"auditLogService");
        this.cache = (NotificationCache)Preconditions.checkNotNull((Object)cache, (Object)"cache");
        this.pacClient = (PacClient)Preconditions.checkNotNull((Object)pacClient, (Object)"pacClient");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.downloadService = (PluginDownloadService)Preconditions.checkNotNull((Object)downloadService, (Object)"downloadService");
        this.pluginInstaller = (PluginInstallationService)Preconditions.checkNotNull((Object)pluginInstaller, (Object)"pluginInstaller");
        this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
        this.selfUpdateController = (SelfUpdateController)Preconditions.checkNotNull((Object)selfUpdateController, (Object)"selfUpdateController");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.scheduler = (UpmScheduler)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.upm = (UpmInformation)Preconditions.checkNotNull((Object)upm, (Object)"upm");
        this.safeMode = (SafeModeAccessor)Preconditions.checkNotNull((Object)safeMode, (Object)"safeMode");
        this.manualUpdateNotificationService = (ManualUpdateRequiredNotificationService)Preconditions.checkNotNull((Object)manualUpdateNotificationService, (Object)"manualUpdateNotificationService");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
        this.hostLicenseInformation = (HostLicenseInformation)Preconditions.checkNotNull((Object)hostLicenseInformation, (Object)hostLicenseInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<AvailableAddonWithVersion> checkForUpdates(PluginUpdateChecker.UpdateCheckOptions options) {
        try {
            Iterable<AvailableAddonWithVersion> allUpdates = options.isUserInitiated() ? this.pacClient.getUpdates() : this.pacClient.getUpdatesViaAutomatedJob();
            Iterable filteredUpdates = Iterables.filter(allUpdates, (Predicate)Predicates.not(this.nonRecentIncompatibleUpdate()));
            Iterable nonUpmUpdates = Iterables.filter((Iterable)filteredUpdates, (Predicate)Predicates.not(this.isUpm()));
            if (options.isUpdateNotifications()) {
                this.cache.setNotifications(NotificationType.PLUGIN_UPDATE_AVAILABLE, (Iterable<String>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)nonUpmUpdates, AvailableAddonWithVersion.toAddonKey())));
            }
            if (options.isInstallAutoUpdates() && this.sysPersisted.is(UpmSettings.AUTO_UPDATE_ENABLED) && !this.safeMode.isSafeMode()) {
                Iterable autoUpdatable = Iterables.filter(allUpdates, this.isAutoUpdateAllowed());
                ImmutableList.Builder freeUpdatableToPaidBuilder = ImmutableList.builder();
                ImmutableList.Builder autoUpdatesBuilder = ImmutableList.builder();
                for (AvailableAddonWithVersion p : autoUpdatable) {
                    for (Plugin installedPlugin : this.pluginRetriever.getPlugin(p.getAddon().getKey())) {
                        if (LicensedPlugins.isFreeUpdatableToPaid(installedPlugin, Option.some(p.getVersion()), this.appManager)) {
                            freeUpdatableToPaidBuilder.add(Pair.pair(p, installedPlugin));
                            continue;
                        }
                        autoUpdatesBuilder.add((Object)p);
                    }
                }
                ImmutableList autoUpdates = autoUpdatesBuilder.build();
                ImmutableList freeUpdatableToPaid = freeUpdatableToPaidBuilder.build();
                if (!Iterables.isEmpty((Iterable)autoUpdates)) {
                    this.scheduler.triggerRunnable(new InstallAutoUpdatesTask((Iterable<AvailableAddonWithVersion>)autoUpdates), Duration.ZERO, "automatic update");
                }
                for (Pair p : freeUpdatableToPaid) {
                    this.logFailedAutoUpdate((AvailableAddonWithVersion)p.first());
                    this.manualUpdateNotificationService.sendFreeToPaidNotification((AvailableAddonWithVersion)p.first());
                }
            }
            Iterable iterable = filteredUpdates;
            return iterable;
        }
        catch (Exception e) {
            log.warn("Automatic plugin update check failed", (Throwable)e);
            this.cache.setNotifications(NotificationType.PLUGIN_UPDATE_AVAILABLE, (Iterable<String>)ImmutableList.of());
            ImmutableList immutableList = ImmutableList.of();
            return immutableList;
        }
        finally {
            this.pacClient.forgetPacReachableState(false);
        }
    }

    private void logFailedAutoUpdate(AvailableAddonWithVersion update) {
        String name = update.getAddon().getName();
        String version = (String)update.getVersion().getName().getOrElse((Object)"");
        this.auditLogService.logI18nMessage("upm.auditLog.auto.update.plugin", name, version);
        this.auditLogService.logI18nMessage("upm.auditLog.auto.update.plugin.failure.needs.permission", name, version);
    }

    private Predicate<AvailableAddonWithVersion> isAutoUpdateAllowed() {
        return new Predicate<AvailableAddonWithVersion>(){

            public boolean apply(AvailableAddonWithVersion availableUpdate) {
                return availableUpdate.getVersion().isAutoUpdateAllowed() && PluginUpdateCheckerImpl.this.pluginRetriever.getPlugin(availableUpdate.getAddon().getKey()).isDefined();
            }
        };
    }

    private Predicate<AvailableAddonWithVersion> nonRecentIncompatibleUpdate() {
        return new Predicate<AvailableAddonWithVersion>(){

            public boolean apply(AvailableAddonWithVersion plugin) {
                for (PluginLicense pluginLicense : PluginUpdateCheckerImpl.this.licenseRepository.getPluginLicense(plugin.getAddon().getKey())) {
                    Iterator<Days> iterator = PluginLicenses.getDaysSinceMaintenanceExpiry(pluginLicense).iterator();
                    if (!iterator.hasNext()) continue;
                    Days days = iterator.next();
                    return days.getDays() >= LicensedAttributes.RECENTLY_EXPIRED_DAYS;
                }
                return false;
            }
        };
    }

    private Predicate<AvailableAddonWithVersion> isUpm() {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)this.upm.getPluginKey()), AvailableAddonWithVersion.toAddonKey());
    }

    private Ordering<AvailableAddonWithVersion> orderingWithUpmAlwaysLast() {
        return new Ordering<AvailableAddonWithVersion>(){

            public int compare(AvailableAddonWithVersion a, AvailableAddonWithVersion b) {
                if (PluginUpdateCheckerImpl.this.upm.getPluginKey().equals(a.getAddon().getKey())) {
                    return 1;
                }
                if (PluginUpdateCheckerImpl.this.upm.getPluginKey().equals(b.getAddon().getKey())) {
                    return -1;
                }
                return a.getAddon().getKey().compareTo(b.getAddon().getKey());
            }
        };
    }

    private class InstallUpmAutoUpdateTask
    implements Runnable {
        private final URI completionUri;
        private final File upmFile;

        InstallUpmAutoUpdateTask(URI completionUri, File upmFile) {
            this.completionUri = completionUri;
            this.upmFile = upmFile;
        }

        @Override
        public void run() {
            Either<String, File> result = PluginUpdateCheckerImpl.this.selfUpdateController.executeInternalSelfUpdate(this.completionUri, this.upmFile);
            for (String error : result.left()) {
                log.error("Unable to update UPM: {}", (Object)error);
            }
        }
    }

    private class InstallAutoUpdatesTask
    implements Runnable {
        private final Iterable<AvailableAddonWithVersion> updates;

        InstallAutoUpdatesTask(Iterable<AvailableAddonWithVersion> autoUpdates) {
            this.updates = PluginUpdateCheckerImpl.this.orderingWithUpmAlwaysLast().sortedCopy(autoUpdates);
        }

        @Override
        public void run() {
            boolean didUpdate = false;
            for (AvailableAddonWithVersion update : this.updates) {
                for (URI downloadUri : update.getVersion().getArtifactUri().orElse(update.getVersion().getRemoteDescriptorUri())) {
                    String name = update.getAddon().getName();
                    String version = (String)update.getVersion().getName().getOrElse((Object)"");
                    PluginUpdateCheckerImpl.this.auditLogService.logI18nMessage("upm.auditLog.auto.update.plugin", name, version);
                    try {
                        PluginDownloadService.DownloadResult downloadResult = PluginUpdateCheckerImpl.this.downloadService.downloadPlugin(downloadUri, Option.some(MarketplacePlugins.getPluginNameAndVersion(update)), PluginDownloadService.NULL_TRACKER);
                        File pluginFile = downloadResult.getFile();
                        if (PluginUpdateCheckerImpl.this.selfUpdateController.isUpmPlugin(pluginFile)) {
                            log.warn("Performing automatic update of UPM from version {} to version {}", (Object)PluginUpdateCheckerImpl.this.upm.getVersionString(), (Object)version);
                            Either<String, URI> prepared = PluginUpdateCheckerImpl.this.selfUpdateController.prepareSelfUpdate(pluginFile, true);
                            for (String error : prepared.left()) {
                                log.error("Unable to update UPM: {}", (Object)error);
                            }
                            for (URI completionUri : prepared.right()) {
                                PluginUpdateCheckerImpl.this.scheduler.triggerRunnable(new InstallUpmAutoUpdateTask(completionUri, pluginFile), Duration.ZERO, "automatic UPM self-update");
                            }
                            return;
                        }
                        if (MarketplacePlugins.isLicensedToBeUpdated(update, PluginUpdateCheckerImpl.this.licenseRepository, PluginUpdateCheckerImpl.this.hostLicenseInformation)) {
                            log.warn("Performing automatic update of \"{}\" to version {}", (Object)name, (Object)version);
                            try {
                                PluginUpdateCheckerImpl.this.pluginInstaller.update(pluginFile, downloadUri.toString(), downloadResult.getContentType(), false);
                                didUpdate = true;
                                PluginUpdateCheckerImpl.this.cache.addNotificationForPlugin(NotificationType.AUTO_UPDATED_PLUGIN, update.getAddon().getKey());
                            }
                            catch (Exception e) {
                                log.warn("An error occurred while trying to update \"{}\": {}", (Object)name, (Object)e.toString());
                                log.debug(e.toString(), (Throwable)e);
                            }
                            continue;
                        }
                        log.warn("Would have automatically updated \"{}\" to version {}, but current license does not permit it", (Object)name, (Object)version);
                    }
                    catch (Exception e) {
                        log.warn("Unable to download \"{}\" from {}; automatic update cancelled", (Object)name, (Object)downloadUri);
                        log.debug(e.toString(), (Throwable)e);
                    }
                }
            }
            if (didUpdate) {
                PluginUpdateCheckerImpl.this.checkForUpdates(PluginUpdateChecker.UpdateCheckOptions.options().userInitiated(false).updateNotifications(true).installAutoUpdates(false));
            }
        }
    }
}

