/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.notification;

import com.atlassian.upm.notification.DismissedState;
import com.atlassian.upm.notification.NotificationType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;

public class Notification {
    private final NotificationType type;
    private final String pluginKey;
    private final DismissedState dismissedState;

    Notification(NotificationType type, String pluginKey, DismissedState dismissedState) {
        this.type = (NotificationType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        this.dismissedState = (DismissedState)Preconditions.checkNotNull((Object)dismissedState, (Object)"dismissedState");
    }

    public NotificationType getType() {
        return this.type;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public DismissedState getDismissedState() {
        return this.dismissedState;
    }

    public static Function<Notification, String> toNotificationPluginKey() {
        return new Function<Notification, String>(){

            public String apply(Notification notification) {
                return notification.getPluginKey();
            }
        };
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Notification && ((Notification)o).getPluginKey().equals(this.getPluginKey());
    }

    public String toString() {
        return "Notification<" + this.getPluginKey() + ">";
    }
}

