/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.mail;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.mail.AbstractAtlassianMailService;
import com.atlassian.upm.mail.UpmEmail;
import com.google.common.base.Preconditions;

public class JiraMailService
extends AbstractAtlassianMailService {
    static final String JIRA_MAIL_SEND_DISABLED = "jira.mail.send.disabled";
    private final MailQueue mailQueue;
    private final ApplicationProperties applicationProperties;
    private final UserUtil userUtil;

    public JiraMailService(MailQueue mailQueue, ApplicationProperties applicationProperties, UserUtil userUtil) {
        this.mailQueue = (MailQueue)Preconditions.checkNotNull((Object)mailQueue, (Object)"mailQueue");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.userUtil = (UserUtil)Preconditions.checkNotNull((Object)userUtil, (Object)"userUtil");
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || this.applicationProperties.getOption(JIRA_MAIL_SEND_DISABLED);
    }

    @Override
    public void sendMail(UpmEmail email) {
        this.mailQueue.addItem(this.createMailQueueItem(email));
    }

    @Override
    public UpmEmail.Format getUserEmailFormatPreference(UserKey userKey) {
        ApplicationUser applicationUser = this.userUtil.getUserByKey(userKey.getStringValue());
        if (applicationUser != null && "text".equals(new NotificationRecipient(applicationUser).getFormat())) {
            return UpmEmail.Format.TEXT;
        }
        return UpmEmail.Format.HTML;
    }

    @Override
    public Option<String> getInstanceName() {
        return Option.option(this.applicationProperties.getText("jira.title"));
    }
}

