/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.api.license.entity.LicenseEditionType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.internal.impl.PluginLicenseImpl;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class PluginLicensesInternal {
    public static boolean isRoleBasedLicense(PluginLicense license) {
        return LicenseEditionType.ROLE_COUNT.equals((Object)license.getEditionType());
    }

    public static Option<Integer> getCurrentRoleCount(PluginLicense license) {
        if (license instanceof PluginLicenseImpl) {
            return ((PluginLicenseImpl)license).getCurrentRoleCount();
        }
        return Option.none();
    }

    public static boolean isServerLicenseValidForDataCenter(DateTime serverLicenseCutoffDate, DateTime purchaseDate, Option<DateTime> maintenanceExpiryDate) {
        if (purchaseDate.isAfter((ReadableInstant)serverLicenseCutoffDate)) {
            return false;
        }
        Iterator<DateTime> iterator = maintenanceExpiryDate.iterator();
        if (iterator.hasNext()) {
            DateTime med = iterator.next();
            if (med.isAfter((ReadableInstant)serverLicenseCutoffDate)) {
                return med.isAfterNow();
            }
            return serverLicenseCutoffDate.isAfterNow();
        }
        return serverLicenseCutoffDate.isAfterNow();
    }
}

