/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.extras.api.Contact;
import com.atlassian.extras.api.Organisation;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.PluginMetadata;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.Partner;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.internal.HostApplicationEmbeddedAddonLicense;
import com.atlassian.upm.license.internal.HostApplicationLicenseAttributes;
import com.atlassian.upm.license.internal.LicenseEntityFactory;
import com.atlassian.upm.license.internal.impl.ContactImpl;
import com.atlassian.upm.license.internal.impl.OrganizationImpl;
import com.atlassian.upm.license.internal.impl.PartnerImpl;
import com.atlassian.upm.license.internal.impl.PluginLicenseBuilder;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensingPluginService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseEntityFactoryImpl
implements LicenseEntityFactory {
    private static final Logger log = LoggerFactory.getLogger(LicenseEntityFactoryImpl.class);
    private static final DateTimeFormatter BF_BUILD_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withOffsetParsed();
    private static final DateTimeFormatter TC_BUILD_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withOffsetParsed();
    private final HostApplicationDescriptor hostApplicationDescriptor;
    private final RoleBasedLicensingPluginService roleBasedLicensingPluginService;
    private final ApplicationProperties applicationProperties;
    private final UpmAppManager appManager;
    private static final Map<String, DateTime> greenhopperBuildDateMap = ImmutableMap.builder().put((Object)"5.9.3", (Object)new DateTime(2012, 3, 26, 0, 0, 0, 0)).put((Object)"5.9.2", (Object)new DateTime(2012, 3, 22, 0, 0, 0, 0)).put((Object)"5.9.1", (Object)new DateTime(2012, 3, 12, 0, 0, 0, 0)).put((Object)"5.9.0", (Object)new DateTime(2012, 2, 21, 0, 0, 0, 0)).put((Object)"5.8.8", (Object)new DateTime(2012, 3, 1, 0, 0, 0, 0)).put((Object)"5.8.7", (Object)new DateTime(2012, 2, 21, 0, 0, 0, 0)).put((Object)"5.8.6", (Object)new DateTime(2012, 1, 30, 0, 0, 0, 0)).put((Object)"5.8.5", (Object)new DateTime(2012, 1, 30, 0, 0, 0, 0)).put((Object)"5.8.4", (Object)new DateTime(2011, 12, 1, 0, 0, 0, 0)).put((Object)"5.8.3", (Object)new DateTime(2011, 11, 14, 0, 0, 0, 0)).put((Object)"5.8.2", (Object)new DateTime(2011, 10, 21, 15, 9, 0, 0)).put((Object)"5.8.1", (Object)new DateTime(2011, 10, 19, 10, 45, 0, 0)).put((Object)"5.8.0", (Object)new DateTime(2011, 10, 11, 13, 54, 0, 0)).put((Object)"5.7.4", (Object)new DateTime(2011, 9, 23, 14, 27, 0, 0)).put((Object)"5.7.3", (Object)new DateTime(2011, 9, 20, 14, 44, 0, 0)).put((Object)"5.7.2", (Object)new DateTime(2011, 9, 7, 15, 41, 0, 0)).put((Object)"5.7.1", (Object)new DateTime(2011, 8, 10, 16, 32, 0, 0)).put((Object)"5.7.0", (Object)new DateTime(2011, 7, 25, 12, 37, 0, 0)).put((Object)"5.6.9", (Object)new DateTime(2011, 7, 14, 10, 2, 0, 0)).put((Object)"5.6.8", (Object)new DateTime(2011, 6, 29, 12, 8, 0, 0)).put((Object)"5.6.7", (Object)new DateTime(2011, 6, 16, 12, 19, 0, 0)).put((Object)"5.6.6", (Object)new DateTime(2011, 6, 14, 14, 59, 0, 0)).put((Object)"5.6.5", (Object)new DateTime(2011, 5, 31, 12, 4, 0, 0)).put((Object)"5.6.4", (Object)new DateTime(2011, 5, 23, 16, 35, 0, 0)).put((Object)"5.6.3", (Object)new DateTime(2011, 5, 20, 11, 15, 0, 0)).put((Object)"5.6.2", (Object)new DateTime(2011, 5, 5, 12, 28, 0, 0)).put((Object)"5.6.1", (Object)new DateTime(2011, 4, 13, 12, 0, 0, 0)).put((Object)"5.6.0", (Object)new DateTime(2011, 3, 30, 17, 35, 0, 0)).put((Object)"5.5.2", (Object)new DateTime(2011, 3, 17, 11, 37, 0, 0)).put((Object)"5.5.1", (Object)new DateTime(2011, 3, 17, 10, 31, 0, 0)).put((Object)"5.5.0", (Object)new DateTime(2011, 3, 15, 17, 30, 0, 0)).put((Object)"5.4.2", (Object)new DateTime(2011, 4, 5, 15, 50, 0, 0)).put((Object)"5.4.1", (Object)new DateTime(2011, 1, 12, 15, 28, 0, 0)).put((Object)"5.4.0", (Object)new DateTime(2010, 12, 9, 10, 18, 0, 0)).put((Object)"5.3.0", (Object)new DateTime(2010, 10, 21, 10, 20, 0, 0)).put((Object)"5.2.4", (Object)new DateTime(2010, 10, 13, 11, 34, 0, 0)).put((Object)"5.2.3", (Object)new DateTime(2010, 10, 1, 11, 28, 0, 0)).put((Object)"5.2.2", (Object)new DateTime(2010, 9, 7, 11, 46, 0, 0)).put((Object)"5.2.1", (Object)new DateTime(2010, 9, 1, 16, 26, 0, 0)).put((Object)"5.2.0", (Object)new DateTime(2010, 7, 30, 12, 23, 0, 0)).put((Object)"5.1.0", (Object)new DateTime(2010, 7, 14, 23, 10, 0, 0)).put((Object)"5.0.1", (Object)new DateTime(2010, 7, 1, 17, 37, 0, 0)).put((Object)"5.0.0", (Object)new DateTime(2010, 6, 9, 18, 9, 0, 0)).put((Object)"4.4.1", (Object)new DateTime(2010, 5, 26, 12, 6, 0, 0)).put((Object)"4.4.0", (Object)new DateTime(2010, 3, 28, 19, 41, 0, 0)).put((Object)"4.3.2", (Object)new DateTime(2010, 5, 3, 19, 37, 0, 0)).put((Object)"4.3.1", (Object)new DateTime(2010, 3, 11, 5, 56, 0, 0)).put((Object)"4.3.0", (Object)new DateTime(2010, 3, 2, 23, 46, 0, 0)).put((Object)"4.3.0.jira40", (Object)new DateTime(2009, 12, 3, 21, 2, 0, 0)).put((Object)"4.2.2.jira40", (Object)new DateTime(2009, 12, 22, 21, 1, 0, 0)).put((Object)"4.2.1.jira40", (Object)new DateTime(2009, 12, 8, 22, 29, 0, 0)).put((Object)"4.2.0.jira40", (Object)new DateTime(2009, 11, 19, 14, 26, 0, 0)).put((Object)"4.1.0.jira40", (Object)new DateTime(2009, 10, 27, 0, 5, 0, 0)).put((Object)"4.0.0.jira40", (Object)new DateTime(2009, 10, 20, 23, 20, 0, 0)).put((Object)"3.7.1.studio-1", (Object)new DateTime(2009, 5, 13, 16, 28, 0, 0)).put((Object)"3.7.0.jirastudio-1", (Object)new DateTime(2009, 5, 13, 16, 28, 0, 0)).put((Object)"3.3.0.studio-4", (Object)new DateTime(2009, 5, 8, 10, 28, 0, 0)).put((Object)"3.3.0.studio-3", (Object)new DateTime(2009, 1, 28, 13, 54, 0, 0)).put((Object)"3.3.0.studio-2", (Object)new DateTime(2009, 1, 28, 12, 8, 0, 0)).put((Object)"3.3.0.studio-1", (Object)new DateTime(2009, 1, 15, 13, 36, 0, 0)).put((Object)"3.3.0.jiraStudio", (Object)new DateTime(2009, 1, 15, 13, 36, 0, 0)).put((Object)"3.1.1.studio-4", (Object)new DateTime(2008, 11, 26, 11, 5, 0, 0)).put((Object)"3.1.1.studio-3", (Object)new DateTime(2008, 11, 17, 12, 41, 0, 0)).put((Object)"3.1.1.jiraStudio", (Object)new DateTime(2008, 11, 17, 12, 41, 0, 0)).put((Object)"3.1.0.studio-2", (Object)new DateTime(2008, 10, 14, 15, 21, 0, 0)).put((Object)"3.1.0.studio-1", (Object)new DateTime(2008, 10, 13, 14, 19, 0, 0)).put((Object)"3.1.0.jiraStudio", (Object)new DateTime(2008, 10, 13, 14, 19, 0, 0)).put((Object)"3.0.2.studio-1", (Object)new DateTime(2008, 10, 1, 11, 3, 0, 0)).put((Object)"3.0.2.jira310", (Object)new DateTime(2008, 10, 1, 11, 3, 0, 0)).build();

    public LicenseEntityFactoryImpl(HostApplicationDescriptor hostApplicationDescriptor, RoleBasedLicensingPluginService roleBasedLicensingPluginService, ApplicationProperties applicationProperties, UpmAppManager appManager) {
        this.hostApplicationDescriptor = (HostApplicationDescriptor)Preconditions.checkNotNull((Object)hostApplicationDescriptor, (Object)"hostApplicationDescriptor");
        this.roleBasedLicensingPluginService = (RoleBasedLicensingPluginService)Preconditions.checkNotNull((Object)roleBasedLicensingPluginService, (Object)"roleBasedLicensingPluginService");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
    }

    @Override
    public com.atlassian.upm.api.license.entity.Contact getContact(Contact contact) {
        return new ContactImpl(contact);
    }

    @Override
    public com.atlassian.upm.api.license.entity.Contact getContact(String name, String email) {
        return new ContactImpl(name, email);
    }

    @Override
    public Organization getOrganization(Organisation organization) {
        return new OrganizationImpl(organization);
    }

    @Override
    public Organization getOrganization(String organizationName) {
        return new OrganizationImpl(organizationName);
    }

    @Override
    public Partner getPartner(com.atlassian.extras.api.Partner partner) {
        return new PartnerImpl(partner);
    }

    @Override
    public Partner getPartner(String partnerName) {
        return new PartnerImpl(partnerName);
    }

    @Override
    public Option<DateTime> getPluginBuildDate(Option<Plugin> maybePlugin) {
        Iterator<DateTime> iterator = PluginMetadata.getPluginBuildDate(maybePlugin).iterator();
        if (iterator.hasNext()) {
            DateTime buildDate = iterator.next();
            return Option.some(buildDate);
        }
        for (Plugin plugin : maybePlugin) {
            Iterator<Bundle> iterator2 = PluginMetadata.getPluginBundle(plugin).iterator();
            if (!iterator2.hasNext()) continue;
            Bundle bundle = iterator2.next();
            return this.getLegacyPluginBuildDate(bundle);
        }
        return Option.none();
    }

    @Override
    public PluginLicense getPluginLicense(ProductLicense pluginLicense, String pluginKey, Option<Plugin> plugin, String rawLicense, HostApplicationLicenseAttributes hostLicense) {
        return PluginLicenseBuilder.from(pluginLicense, pluginKey, plugin, rawLicense, hostLicense, this.roleBasedLicensingPluginService, this, this.applicationProperties).build();
    }

    @Override
    public PluginLicense getPluginLicense(HostApplicationEmbeddedAddonLicense pluginLicense, Option<Plugin> plugin, HostApplicationLicenseAttributes hostLicense) {
        return PluginLicenseBuilder.from(pluginLicense, plugin, hostLicense, this).build();
    }

    private Option<DateTime> getLegacyPluginBuildDate(Bundle bundle) {
        String pluginKey = bundle.getSymbolicName();
        if (pluginKey.equals("com.pyxis.greenhopper.jira")) {
            return Option.option(greenhopperBuildDateMap.get(bundle.getVersion().toString()));
        }
        if (pluginKey.equals("com.atlassian.confluence.extra.team-calendars")) {
            return this.getTeamCalendarsBuildDateString(bundle).flatMap(this.toDate(TC_BUILD_DATE_FORMAT));
        }
        if (pluginKey.equals("com.atlassian.bonfire.plugin")) {
            return this.getBonfirePluginBuildDateString(bundle).flatMap(this.toDate(BF_BUILD_DATE_FORMAT));
        }
        return Option.none();
    }

    private Option<String> getTeamCalendarsBuildDateString(Bundle bundle) {
        return this.getPropertyFromResourceUrl("build.date", bundle.getResource("com/atlassian/confluence/extra/calendar3/build.properties"));
    }

    private Option<String> getBonfirePluginBuildDateString(Bundle bundle) {
        return this.getPropertyFromResourceUrl("build.time", bundle.getResource("build/build.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<String> getPropertyFromResourceUrl(String propertyName, URL resourceUrl) {
        Option<String> option;
        if (resourceUrl == null) {
            return Option.none();
        }
        Properties properties = new Properties();
        InputStream is = resourceUrl.openStream();
        try {
            properties.load(resourceUrl.openStream());
            option = Option.option(properties.getProperty(propertyName));
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Unable to open stream " + resourceUrl.toString());
                return Option.none();
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return option;
    }

    private Function<String, Option<DateTime>> toDate(final DateTimeFormatter buildDateFormat) {
        return new Function<String, Option<DateTime>>(){

            public Option<DateTime> apply(String dateString) {
                try {
                    return Option.some(buildDateFormat.parseDateTime(dateString));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Invalid Build Date of \"" + dateString + "\"");
                    return Option.none();
                }
            }
        };
    }
}

