/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.impl;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.PluginsEnablementState;
import com.atlassian.upm.core.PluginsEnablementStateAccessor;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class PluginSettingsPluginsEnablementStateAccessor
implements PluginsEnablementStateAccessor {
    private static final String KEY_PREFIX = "com.atlassian.upm.ConfigurationStore:configuration:";
    protected static final String UPM_CONFIGURATION_KEY = "upm_configuration";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper mapper;

    public PluginSettingsPluginsEnablementStateAccessor(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public boolean hasSavedConfiguration() throws PluginsEnablementStateAccessor.PluginsEnablementStateStoreException {
        return this.getSavedConfiguration().isDefined();
    }

    @Override
    public Option<PluginsEnablementState> getSavedConfiguration() throws PluginsEnablementStateAccessor.PluginsEnablementStateStoreException {
        try {
            Iterator<String> iterator = this.getConfigurationString().iterator();
            if (iterator.hasNext()) {
                String val = iterator.next();
                return this.getConfigurationFromString(val);
            }
        }
        catch (Exception e) {
            throw new PluginsEnablementStateAccessor.PluginsEnablementStateStoreException("Unable to read saved configuration", e);
        }
        return Option.none(PluginsEnablementState.class);
    }

    protected Option<String> getConfigurationString() {
        for (Object val : Option.option(this.getPluginSettings().get(UPM_CONFIGURATION_KEY))) {
            if (!(val instanceof String)) continue;
            return Option.some(String.valueOf(val));
        }
        return Option.none();
    }

    private Option<PluginsEnablementState> getConfigurationFromString(String value) throws IOException {
        String decompressedValue;
        byte[] bytes = Base64.decodeBase64((byte[])value.getBytes(StandardCharsets.UTF_8));
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
             GZIPInputStream gzipIn = new GZIPInputStream(bis);){
            decompressedValue = IOUtils.toString((InputStream)gzipIn, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException error) {
            return Option.some(this.mapper.readValue(value, PluginsEnablementState.class));
        }
        return Option.some(this.mapper.readValue(decompressedValue, PluginsEnablementState.class));
    }

    protected PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), KEY_PREFIX);
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }
}

