/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.analytics.event;

import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.PluginControlHandlerRegistry;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.DefaultHostApplicationInformation;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.analytics.event.PluginAnalyticsEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;

public class PluginUpdateRequestEvent
extends PluginAnalyticsEvent {
    private final Map<String, String> metadata;

    private PluginUpdateRequestEvent(PluginUpdateRequestEventBuilder builder, Plugin plugin, DefaultHostApplicationInformation hostApplicationInformation) {
        super(plugin, hostApplicationInformation);
        this.metadata = builder.metadata.build();
    }

    private PluginUpdateRequestEvent(PluginUpdateRequestEventBuilder builder, Addon addon, AddonVersion version, DefaultHostApplicationInformation hostApplicationInformation) {
        super(addon.getKey(), (String)version.getName().getOrElse((Object)""), Plugins.getAddonHostingType(addon, hostApplicationInformation));
        this.metadata = builder.metadata.build();
    }

    @Override
    public String getEventType() {
        return "plugin-update-request";
    }

    @Override
    public Iterable<Pair<String, String>> getMetadata() {
        return Iterables.transform(this.metadata.entrySet(), Pair.fromMapEntry());
    }

    public static class PluginUpdateRequestEventBuilder {
        private Option<Plugin> installedPlugin = Option.none();
        private Option<Addon> availablePlugin = Option.none();
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();
        private DefaultHostApplicationInformation hostApplicationInformation;

        public static PluginUpdateRequestEventBuilder builderForInstalledPlugin(Plugin installedPlugin, PluginControlHandlerRegistry pluginControlHandlerRegistry, DefaultHostApplicationInformation hostApplicationInformation) {
            PluginUpdateRequestEventBuilder builder = new PluginUpdateRequestEventBuilder();
            builder.installedPlugin = Option.some(installedPlugin);
            builder.hostApplicationInformation = hostApplicationInformation;
            return builder;
        }

        public static PluginUpdateRequestEventBuilder builderForAvailablePlugin(Addon availablePlugin, DefaultHostApplicationInformation hostApplicationInformation) {
            PluginUpdateRequestEventBuilder builder = new PluginUpdateRequestEventBuilder();
            builder.availablePlugin = Option.some(availablePlugin);
            builder.hostApplicationInformation = hostApplicationInformation;
            return builder;
        }

        public PluginUpdateRequestEvent build() {
            if (this.availablePlugin.isDefined() && this.availablePlugin.get().getVersion().isDefined()) {
                return new PluginUpdateRequestEvent(this, this.availablePlugin.get(), (AddonVersion)this.availablePlugin.get().getVersion().get(), this.hostApplicationInformation);
            }
            Iterator<Plugin> iterator = this.installedPlugin.iterator();
            if (iterator.hasNext()) {
                Plugin p = iterator.next();
                return new PluginUpdateRequestEvent(this, p, this.hostApplicationInformation);
            }
            throw new IllegalArgumentException("Missing required parameters");
        }

        public PluginUpdateRequestEventBuilder applicationProperties(ApplicationProperties applicationProperties) {
            this.metadata.put((Object)"app", (Object)applicationProperties.getDisplayName());
            this.metadata.put((Object)"appVersion", (Object)applicationProperties.getVersion());
            return this;
        }

        public PluginUpdateRequestEventBuilder message(Option<String> message) {
            for (String m : message) {
                this.metadata.put((Object)"message", (Object)m);
            }
            return this;
        }

        public PluginUpdateRequestEventBuilder userInitiated(boolean userInitiated) {
            this.metadata.put((Object)"automated", (Object)Boolean.toString(!userInitiated));
            return this;
        }

        public PluginUpdateRequestEventBuilder dataCenterIncompatible(boolean dataCenterIncompatible) {
            this.metadata.put((Object)"dataCenterIncompatible", (Object)Boolean.toString(dataCenterIncompatible));
            return this;
        }

        public PluginUpdateRequestEventBuilder email(Option<String> email) {
            for (String e : email) {
                this.metadata.put((Object)"email", (Object)e);
            }
            return this;
        }

        public PluginUpdateRequestEventBuilder fullName(Option<String> fullName) {
            for (String name : fullName) {
                this.metadata.put((Object)"fullName", (Object)name);
            }
            return this;
        }
    }
}

