/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.analytics.event;

import com.atlassian.upm.analytics.event.UpmAnalyticsEvent;
import com.atlassian.upm.api.util.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class PluginRequestedAnalyticsEvent
extends UpmAnalyticsEvent {
    private final String pluginKey;
    private final boolean newRequest;

    public PluginRequestedAnalyticsEvent(String pluginKey, boolean newRequest) {
        this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        this.newRequest = newRequest;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public boolean isNewRequest() {
        return this.newRequest;
    }

    @Override
    public String getEventType() {
        return "requested";
    }

    @Override
    public Iterable<Pair<String, String>> getInvolvedPluginVersions() {
        return ImmutableList.of();
    }

    @Override
    public Iterable<Pair<String, String>> getMetadata() {
        return ImmutableList.of(Pair.pair("new-request", Boolean.toString(this.isNewRequest())), Pair.pair("pk", this.pluginKey));
    }
}

