/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.PricingType;
import com.atlassian.marketplace.client.model.Addon;
import com.atlassian.marketplace.client.model.AddonBase;
import com.atlassian.marketplace.client.model.AddonVersion;
import com.atlassian.marketplace.client.model.AddonVersionBase;
import com.atlassian.marketplace.client.model.ImageInfo;
import com.atlassian.marketplace.client.model.LicenseType;
import com.atlassian.marketplace.client.model.PaymentModel;
import com.atlassian.marketplace.client.model.VendorSummary;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.UpmHostApplicationInformation;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.impl.PluginLicenseImpl;
import com.atlassian.upm.license.internal.impl.PluginLicensesInternal;
import com.atlassian.upm.pac.AvailableAddonWithVersion;
import com.atlassian.upm.pac.IncompatiblePluginData;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarketplacePlugins {
    private static final Logger log = LoggerFactory.getLogger(MarketplacePlugins.class);

    public static Boolean isInstallable(AddonVersionBase version, ApplicationProperties applicationProperties) {
        return version.isDeployable() && (!version.isStatic() || ((ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties")).getDisplayName().equalsIgnoreCase(ApplicationKey.CONFLUENCE.getKey())) && version.getArtifactUri().isDefined();
    }

    public static String getMarketplaceTypeFromPaymentModel(PaymentModel paymentModel) {
        return paymentModel.name();
    }

    public static String getPluginNameAndVersion(AvailableAddonWithVersion update) {
        return update.getAddon().getName() + " " + (String)update.getVersion().getName().getOrElse((Object)"");
    }

    public static String getPluginNameAndVersion(Addon plugin) {
        Iterator iterator = plugin.getVersion().iterator();
        if (iterator.hasNext()) {
            AddonVersion version = (AddonVersion)iterator.next();
            return plugin.getName() + " " + (String)version.getName().getOrElse((Object)"");
        }
        return plugin.getName();
    }

    public static String getSupportTypeName(AddonBase addon, AddonVersionBase version) {
        if (!version.isSupported()) {
            return "unsupported";
        }
        for (VendorSummary vendor : addon.getVendor()) {
            if (!vendor.getName().contains("Atlassian")) continue;
            return "atlassian";
        }
        return "vendor";
    }

    private static Predicate<AvailableAddonWithVersion> isLicensedToBeUpdated(PluginLicenseRepository licenseRepository, HostLicenseInformation hostLicenseInformation, DateTime serverLicenseCutoffDate) {
        return new IsLicensedToBeUpdated(licenseRepository, hostLicenseInformation, serverLicenseCutoffDate);
    }

    public static boolean isLicensedToBeUpdated(AvailableAddonWithVersion plugin, PluginLicenseRepository licenseRepository, HostLicenseInformation hostLicenseInformation) {
        return MarketplacePlugins.isLicensedToBeUpdated(plugin, licenseRepository, hostLicenseInformation, PluginLicenseImpl.SERVER_LICENSE_CUTOFF_DATE);
    }

    protected static boolean isLicensedToBeUpdated(AvailableAddonWithVersion plugin, PluginLicenseRepository licenseRepository, HostLicenseInformation hostLicenseInformation, DateTime serverLicenseCutoffDate) {
        return MarketplacePlugins.isLicensedToBeUpdated(licenseRepository, hostLicenseInformation, serverLicenseCutoffDate).apply((Object)plugin);
    }

    public static Option<DateTime> getExpectedDataCenterVersionLicenseExpiryDate(AvailableAddonWithVersion plugin, PluginLicenseRepository licenseRepository, HostLicenseInformation hostLicenseInformation) {
        if (hostLicenseInformation.isDataCenter()) {
            return Option.some(licenseRepository.getPluginLicense(plugin.getAddon().getKey()).flatMap(l -> l.isDataCenter() ? l.getExpiryDate() : l.getMaintenanceExpiryDate().map(med -> med.isAfter((ReadableInstant)PluginLicenseImpl.SERVER_LICENSE_CUTOFF_DATE) ? med : PluginLicenseImpl.SERVER_LICENSE_CUTOFF_DATE)).getOrElse(PluginLicenseImpl.SERVER_LICENSE_CUTOFF_DATE));
        }
        return Option.none();
    }

    public static boolean isDataCenterIncompatible(Plugin plugin, UpmHostApplicationInformation appInfo) {
        return appInfo.isHostDataCenterEnabled() ? plugin.isUserInstalled() && !Plugins.isStatusDataCenterCompatibleAccordingToPluginDescriptor(plugin) : false;
    }

    public static boolean isDataCenterIncompatible(AddonVersionBase version, UpmHostApplicationInformation appInfo) {
        return appInfo.isHostDataCenterEnabled() && !version.isDataCenterStatusCompatible();
    }

    public static PricingType getPricingType(AddonVersionBase version) {
        return version.isDataCenterStatusCompatible() ? PricingType.DATA_CENTER : PricingType.SERVER;
    }

    public static boolean isLegacyDataCenterIncompatible(Plugin plugin, UpmHostApplicationInformation appInfo) {
        if (appInfo.isHostDataCenterEnabled()) {
            return plugin.isUserInstalled() && !Plugins.isLegacyDataCenterCompatibleAccordingToPluginDescriptor(plugin);
        }
        return false;
    }

    public static boolean isLegacyDataCenterIncompatible(AddonVersionBase version, UpmHostApplicationInformation appInfo) {
        if (appInfo.isHostDataCenterEnabled()) {
            return !version.isDataCenterCompatible();
        }
        return false;
    }

    public static Predicate<IncompatiblePluginData> enabled(final PluginRetriever pluginRetriever) {
        return new Predicate<IncompatiblePluginData>(){

            public boolean apply(IncompatiblePluginData plugin) {
                return pluginRetriever.isPluginEnabled(plugin.getKey());
            }
        };
    }

    public static Predicate<IncompatiblePluginData> withIncompatiblePluginKey(final String pluginKey) {
        return new Predicate<IncompatiblePluginData>(){

            public boolean apply(IncompatiblePluginData plugin) {
                return pluginKey.equals(plugin.getKey());
            }
        };
    }

    public static Function<ImageInfo, URI> imageURI() {
        return new Function<ImageInfo, URI>(){

            public URI apply(ImageInfo image) {
                return image.getImageUri();
            }
        };
    }

    public static Function<ImageInfo, Option<URI>> imageTinyVersionURI() {
        return new Function<ImageInfo, Option<URI>>(){

            public Option<URI> apply(ImageInfo image) {
                return UpmFugueConverters.toUpmOption(image.getImageUri(ImageInfo.Size.SMALL_SIZE, ImageInfo.Resolution.DEFAULT_RESOLUTION));
            }
        };
    }

    public static Function<LicenseType, String> licenseTypeName() {
        return new Function<LicenseType, String>(){

            public String apply(LicenseType lt) {
                return lt.getName();
            }
        };
    }

    public static Function<LicenseType, Option<URI>> licenseTypeURI() {
        return new Function<LicenseType, Option<URI>>(){

            public Option<URI> apply(LicenseType lt) {
                return UpmFugueConverters.toUpmOption(lt.getAlternateUri());
            }
        };
    }

    private static class IsLicensedToBeUpdated
    implements Predicate<AvailableAddonWithVersion> {
        private final PluginLicenseRepository licenseRepository;
        private final HostLicenseInformation hostLicenseInformation;
        private final DateTime serverLicenseCutoffDate;

        public IsLicensedToBeUpdated(PluginLicenseRepository licenseRepository, HostLicenseInformation hostLicenseInformation, DateTime serverLicenseCutoffDate) {
            this.licenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)licenseRepository, (Object)"licenseRepository");
            this.hostLicenseInformation = (HostLicenseInformation)Preconditions.checkNotNull((Object)hostLicenseInformation, (Object)"hostLicenseInformation");
            this.serverLicenseCutoffDate = (DateTime)Preconditions.checkNotNull((Object)serverLicenseCutoffDate, (Object)serverLicenseCutoffDate);
        }

        public boolean apply(AvailableAddonWithVersion pv) {
            for (PluginLicense pluginLicense : this.licenseRepository.getPluginLicense(pv.getAddon().getKey())) {
                if (!pluginLicense.isValid()) {
                    return true;
                }
                if (pluginLicense.getMaintenanceExpiryDate().exists((Predicate<DateTime>)((Predicate)med -> pv.getVersion().getReleaseDate().isAfter((ReadablePartial)med.toLocalDate())))) {
                    return false;
                }
                if (!this.hostLicenseInformation.isDataCenter() || pluginLicense.isDataCenter() || !pv.getVersion().isDataCenterStatusCompatible() || PluginLicensesInternal.isServerLicenseValidForDataCenter(this.serverLicenseCutoffDate, pluginLicense.getPurchaseDate(), pluginLicense.getMaintenanceExpiryDate())) continue;
                return false;
            }
            return true;
        }
    }
}

