package com.atlassian.theme.internal;

import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;

import javax.annotation.Nonnull;

/**
 * Just stubbing out all the defaults, maybe we could use the plugin system for registration or do it programmatically,
 * thinking ahead in case we want this to be extensible
 */
public class DefaultThemes {
    public static final Theme DARK = new Theme() {
        @Nonnull
        @Override
        public ThemeColorMode getColorMode() {
            return ThemeColorMode.DARK;
        }

        @Nonnull
        @Override
        public String getThemeKey() {
            // do not change -- this is CSS selector API and REST API
            return "dark";
        }

        @Nonnull
        @Override
        public String getThemeI18nNameKey() {
            // Provided by the plugin
            return "atlassian.theme.themes.default.dark.name";
        }
    };

    public static final Theme LIGHT = new Theme() {
        @Nonnull
        @Override
        public ThemeColorMode getColorMode() {
            return ThemeColorMode.LIGHT;
        }

        @Nonnull
        @Override
        public String getThemeKey() {
            // do not change -- this is CSS selector API and REST API
            return "light";
        }

        @Nonnull
        @Override
        public String getThemeI18nNameKey() {
            // Provided by the plugin
            return "atlassian.theme.themes.default.light.name";
        }
    };

    public static final Theme ORIGINAL = new Theme() {
        @Nonnull
        @Override
        public ThemeColorMode getColorMode() {
            return ThemeColorMode.LIGHT;
        }

        @Nonnull
        @Override
        public String getThemeKey() {
            // do not change -- this is REST API
            return "original";
        }

        @Nonnull
        @Override
        public String getThemeI18nNameKey() {
            // Provided by the plugin
            return "atlassian.theme.themes.default.original.name";
        }
    };
}
