package com.atlassian.theme.internal.api;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

@ReturnValuesAreNonnullByDefault
public interface ThemeService {
    /**
     * All the themes that a user could potentially set. Theme keys are unique
     */
    List<Theme> getAllAvailableThemes();

    /**
     * Attempt to find a matching theme for the key and color mode
     */
    Optional<Theme> findMatchingTheme(@Nonnull ThemeColorMode themeColorMode, @Nullable String themeKey);
}
