package com.atlassian.tenancy.api.helper;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantUnavailableException;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;

import java.util.Collections;
import java.util.concurrent.Callable;

/**
 * Helper methods for performing bulk actions on tenants.
 */
@ExperimentalApi
@Deprecated
public class TenantAccessors {

    private TenantAccessors() {}

    @Deprecated
    public static <T> Iterable<Either<Failure, Option<T>>> forEachTenant(final TenantAccessor tenantAccessor, final Callable<T> callable) {
        return Iterables.flatMap(tenantAccessor.getAvailableTenants(), tenant -> {
            try {
                final T result = tenantAccessor.asTenant(tenant, callable);
                return Collections.singleton(Either.right(result != null ? Option.some(result) : Option.none()));
            } catch (TenantUnavailableException e) {
                // Tenant went away after we were told it existed. Not a problem.
                return Collections.emptyList();
            } catch (Exception e) {
                return Collections.singleton(Either.left(new Failure(tenant, e)));
            }
        });
    }

    @Deprecated
    public static Iterable<Failure> forEachTenant(final TenantAccessor tenantAccessor, final Runnable runnable) {
        return Iterables.flatMap(forEachTenant(tenantAccessor, () -> {
            runnable.run();
            return null;
        }), either -> either.left());
    }
}
