package com.atlassian.tenancy.api.helper;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helper class for doing per-tenant initialisation the simplest way
 * possible.
 *
 * <p>Notes for writing a setup procedure:</p>
 *
 * <ul>
 *     <li>The passed-in runnable must be reusable and re-entrant.
 *     <li>Under some circumstances, the procedure may be called more than once
 *         for a single tenant.
 *     <li>The initialiser makes no attempt to handle errors, so all errors must
 *         be taken care of inside tenantSetupProcedure. Any exceptions leaked by
 *         the init code will be turned into log-spam.
 * </ul>
 */
@Deprecated
public class PerTenantInitialiser {
    private static final Logger log = LoggerFactory.getLogger(PerTenantInitialiser.class);

    private final EventPublisher eventPublisher;
    private final TenantAccessor tenantAccessor;
    private final Runnable tenantSetupProcedure;

    public PerTenantInitialiser(EventPublisher eventPublisher, TenantAccessor tenantAccessor, Runnable tenantSetupProcedure) {
        this.eventPublisher = eventPublisher;
        this.tenantAccessor = tenantAccessor;
        this.tenantSetupProcedure = tenantSetupProcedure;
    }

    @Deprecated
    public void init() {
        eventPublisher.register(this);

        for (Failure failure: TenantAccessors.forEachTenant(tenantAccessor, tenantSetupProcedure)) {
            log.error("Setup for tenant " + failure.getTenant() + " failed: " + failure.getException(), failure.getException());
        }
    }

    @EventListener
    @Deprecated
    public void onTenantArrived(TenantArrivedEvent event) {
        try {
            tenantSetupProcedure.run();
        } catch (RuntimeException e) {
            log.error("Setup for tenant " + event.getTenant() + " failed: " + e, e);
        }
    }

    @Deprecated
    public void destroy() {
        eventPublisher.unregister(this);
    }
}
