/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.allowlist.uberspect;

import com.atlassian.plugin.util.ContextClassLoaderSettingInvocationHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.apache.velocity.util.introspection.MethodTranslatorImpl;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.InfrastructureProxy;

public class AtlassianMethodTranslator
extends MethodTranslatorImpl {
    private static final Logger log = LoggerFactory.getLogger(AtlassianMethodTranslator.class);
    private final Map<Method, Method> unproxyMethodCache = Collections.synchronizedMap(new WeakHashMap());
    private final Field cclTargetField;
    public static final String HTMLSAFE_HANDLER_NAME = "com.atlassian.velocity.htmlsafe.introspection.AnnotationPreservingInvocationHandler";
    private final Class<InvocationHandler> htmlSafeHandlerClass = Class.forName("com.atlassian.velocity.htmlsafe.introspection.AnnotationPreservingInvocationHandler");
    private final Field htmlSafeTargetField;
    public static final String OSGI_COMPONENT_HANDLER_NAME = "com.atlassian.plugin.osgi.bridge.external.HostComponentFactoryBean$DynamicServiceInvocationHandler";
    private Class<InvocationHandler> osgiComponentHandlerClass;
    private Field osgiComponentTargetField;

    public AtlassianMethodTranslator() throws Exception {
        this.cclTargetField = ContextClassLoaderSettingInvocationHandler.class.getDeclaredField("service");
        this.htmlSafeTargetField = this.htmlSafeHandlerClass.getDeclaredField("targetObject");
        this.cclTargetField.setAccessible(true);
        this.htmlSafeTargetField.setAccessible(true);
    }

    private void initialiseOsgiComponentFields(Class<?> osgiComponentHandlerClass) {
        this.osgiComponentHandlerClass = osgiComponentHandlerClass;
        try {
            this.osgiComponentTargetField = osgiComponentHandlerClass.getDeclaredField("service");
            this.osgiComponentTargetField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public Method getTranslatedMethod(Object target, Method method) {
        if (!this.isProxy(target.getClass()) && !Modifier.isAbstract(method.getModifiers())) {
            return method;
        }
        return this.getUnproxiedSpecificMethodCached(target, method);
    }

    protected Method getUnproxiedSpecificMethodCached(Object target, Method method) {
        return this.unproxyMethodCache.computeIfAbsent(method, key -> this.getUnproxiedSpecificMethod(target, (Method)key));
    }

    protected Method getUnproxiedSpecificMethod(Object target, Method method) {
        if (!this.isProxy(target.getClass())) {
            return AopUtils.getMostSpecificMethod((Method)method, target.getClass());
        }
        for (Function<Object, ?> unproxyingFunction : this.unproxyingFunctions()) {
            Object newTarget = unproxyingFunction.apply(target);
            if (newTarget == target || newTarget == null) continue;
            return this.getUnproxiedSpecificMethodCached(newTarget, method);
        }
        Class<?> newTargetClass = this.classUnproxyingFunction(target);
        if (!this.isProxy(newTargetClass)) {
            return AopUtils.getMostSpecificMethod((Method)method, newTargetClass);
        }
        Method interfaceMethod = super.getTranslatedMethod(target, method);
        log.debug("Unproxying failed{}, falling back to interface method: {}", (Object)(Proxy.isProxyClass(target.getClass()) ? " for dynamic proxy with handler %s".formatted(Proxy.getInvocationHandler(target).getClass()) : ""), (Object)interfaceMethod);
        return interfaceMethod;
    }

    protected List<Function<Object, ?>> unproxyingFunctions() {
        return List.of(this::getHibernateProxyTarget, this::getSpringAdvisedProxyTarget, this::getSpringInfraProxyTarget, this::getContextClassLoaderProxyTarget, this::getHtmlSafeProxyTarget, this::getOsgiComponentProxyTarget);
    }

    protected Class<?> classUnproxyingFunction(Object target) {
        Class<?> result = null;
        if (AtlassianMethodTranslator.isImplementsInterfaceReflective(target, TargetClassAware.class)) {
            result = (Class<?>)AtlassianMethodTranslator.reflectiveMethodCallNoArgs(target, "getTargetClass");
        }
        if (result == null) {
            result = AtlassianMethodTranslator.isCglibProxy(target) ? target.getClass().getSuperclass() : target.getClass();
        }
        return result;
    }

    protected Object getHibernateProxyTarget(Object proxy) {
        try {
            if (proxy instanceof HibernateProxy) {
                return Hibernate.unproxy((Object)proxy);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return proxy;
    }

    protected Object getSpringAdvisedProxyTarget(Object proxy) {
        if (AtlassianMethodTranslator.isImplementsInterfaceReflective(proxy, Advised.class)) {
            Object targetSource = AtlassianMethodTranslator.reflectiveMethodCallNoArgs(proxy, "getTargetSource");
            try {
                return AtlassianMethodTranslator.reflectiveMethodCallNoArgs(targetSource, "getTarget");
            }
            catch (Exception e) {
                return proxy;
            }
        }
        return proxy;
    }

    protected Object getSpringInfraProxyTarget(Object proxy) {
        if (AtlassianMethodTranslator.isImplementsInterfaceReflective(proxy, InfrastructureProxy.class)) {
            return AtlassianMethodTranslator.reflectiveMethodCallNoArgs(proxy, "getWrappedObject");
        }
        return proxy;
    }

    protected Object getContextClassLoaderProxyTarget(Object proxy) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(proxy.getClass()) && (invocationHandler = Proxy.getInvocationHandler(proxy)) instanceof ContextClassLoaderSettingInvocationHandler) {
            ContextClassLoaderSettingInvocationHandler invocationHandler2 = (ContextClassLoaderSettingInvocationHandler)invocationHandler;
            return this.getService(invocationHandler2);
        }
        return proxy;
    }

    protected Object getHtmlSafeProxyTarget(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass()) && Proxy.getInvocationHandler(proxy).getClass().equals(this.htmlSafeHandlerClass)) {
            return this.getHtmlSafeTarget(Proxy.getInvocationHandler(proxy));
        }
        return proxy;
    }

    protected Object getOsgiComponentProxyTarget(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
            Class<?> handlerClass = invocationHandler.getClass();
            if (this.osgiComponentHandlerClass != null && this.osgiComponentHandlerClass.equals(handlerClass)) {
                return this.getOsgiComponentTarget(invocationHandler);
            }
            if (handlerClass.getName().equals(OSGI_COMPONENT_HANDLER_NAME)) {
                this.initialiseOsgiComponentFields(handlerClass);
                return this.getOsgiComponentTarget(invocationHandler);
            }
        }
        return proxy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isImplementsInterfaceReflective(Object target, Class<?> iface) {
        if (target == null) return false;
        if (!ClassUtils.getAllInterfaces(target.getClass()).stream().map(Class::getName).anyMatch(iface.getName()::equals)) return false;
        return true;
    }

    private static Object reflectiveMethodCallNoArgs(Object target, String methodName) {
        try {
            Method method = target.getClass().getMethod(methodName, new Class[0]);
            return method.invoke(target, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isCglibProxy(Object object) {
        return AtlassianMethodTranslator.isImplementsInterfaceReflective(object, SpringProxy.class) && object.getClass().getName().contains("$$");
    }

    private Object getService(ContextClassLoaderSettingInvocationHandler handler) {
        try {
            return this.cclTargetField.get(handler);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getHtmlSafeTarget(InvocationHandler handler) {
        try {
            return this.htmlSafeTargetField.get(handler);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getOsgiComponentTarget(InvocationHandler handler) {
        try {
            return this.osgiComponentTargetField.get(handler);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isProxy(Class<?> clazz) {
        return clazz.getSimpleName().contains("$");
    }
}

