/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.velocity;

import com.atlassian.velocity.htmlsafe.annotations.ReturnValueAnnotation;
import com.atlassian.velocity.htmlsafe.introspection.MethodAnnotator;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateRendererReturnValueAnnotator
implements MethodAnnotator {
    private static final Logger log = LoggerFactory.getLogger(TemplateRendererReturnValueAnnotator.class);
    private final LoadingCache<Annotation, Boolean> annotationCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Annotation, Boolean>(){

        public Boolean load(Annotation annotation) {
            return annotation.annotationType().isAnnotationPresent(ReturnValueAnnotation.class) || annotation.annotationType().isAnnotationPresent(com.atlassian.templaterenderer.annotations.ReturnValueAnnotation.class);
        }
    });

    @Override
    public Collection<Annotation> getAnnotationsForMethod(Method method) {
        HashSet<Annotation> returnValueAnnotations = new HashSet<Annotation>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!((Boolean)this.annotationCache.getUnchecked((Object)annotation)).booleanValue()) continue;
            returnValueAnnotations.add(annotation);
        }
        return Collections.unmodifiableCollection(returnValueAnnotations);
    }
}

