/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.htmlsafe;

import com.atlassian.velocity.htmlsafe.HtmlEntities;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.velocity.htmlsafe.HtmlSafeAnnotationUtils;
import com.atlassian.velocity.htmlsafe.RawVelocityReference;
import com.atlassian.velocity.htmlsafe.introspection.AnnotatedReferenceHandler;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAnnotationEscaper
extends AnnotatedReferenceHandler {
    private static final Set SAFE_REFERENCE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xHtmlContent", "body")));

    @Override
    protected Object annotatedValueInsert(String referenceName, Object value, Collection<Annotation> annotations) {
        if (value == null) {
            return null;
        }
        if (this.shouldEscape(referenceName, value, annotations)) {
            return HtmlEntities.encode(value.toString());
        }
        return value;
    }

    private boolean shouldEscape(String referenceName, Object value, Collection<Annotation> annotations) {
        String baseReference;
        RawVelocityReference reference = new RawVelocityReference(referenceName);
        if (reference.isScalar() && ((baseReference = reference.getBaseReferenceName()).toLowerCase().endsWith("html") || SAFE_REFERENCE_NAMES.contains(baseReference))) {
            return false;
        }
        return !HtmlSafeAnnotationUtils.hasHtmlSafeToStringMethod(value) && !HtmlSafeAnnotationUtils.containsAnnotationOfType(annotations, HtmlSafe.class);
    }
}

