/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.velocity.one.six.internal;

import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateContextFactory;
import com.atlassian.templaterenderer.velocity.CompositeClassLoader;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.atlassian.templaterenderer.velocity.one.six.internal.TemplateRendererHtmlAnnotationEscaper;
import com.atlassian.velocity.htmlsafe.HtmlSafeDirective;
import com.atlassian.velocity.htmlsafe.introspection.HtmlSafeAnnotationBoxingUberspect;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTemplateRendererImpl
implements VelocityTemplateRenderer {
    private final ClassLoader classLoader;
    private final String pluginKey;
    private final TemplateContextFactory templateContextFactory;
    private final VelocityEngine velocity;

    public VelocityTemplateRendererImpl(ClassLoader classLoader, String pluginKey, Map<String, String> properties, TemplateContextFactory templateContextFactory) {
        this.classLoader = classLoader;
        this.pluginKey = pluginKey;
        this.templateContextFactory = templateContextFactory;
        this.velocity = new VelocityEngine();
        this.velocity.addProperty("runtime.log.logsystem.class", CommonsLogLogChute.class.getName());
        this.velocity.addProperty("resource.loader", "classpath");
        this.velocity.addProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
        this.velocity.addProperty("runtime.introspector.uberspect", HtmlSafeAnnotationBoxingUberspect.class.getName());
        this.velocity.addProperty("userdirective", HtmlSafeDirective.class.getName());
        this.velocity.addProperty("eventhandler.referenceinsertion.class", TemplateRendererHtmlAnnotationEscaper.class.getName());
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            this.velocity.addProperty(prop.getKey(), prop.getValue());
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        CompositeClassLoader compositeClassLoader = new CompositeClassLoader(this.getClass().getClassLoader(), classLoader);
        Thread.currentThread().setContextClassLoader(compositeClassLoader);
        try {
            this.velocity.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void render(String templateName, Writer writer) throws RenderingException, IOException {
        this.render(templateName, Collections.<String, Object>emptyMap(), writer);
    }

    public void render(String templateName, Map<String, Object> context, Writer writer) throws RenderingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Template template = this.velocity.getTemplate(templateName);
            template.merge(this.createContext(context), writer);
            writer.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RenderingException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public String renderFragment(String fragment, Map<String, Object> context) {
        try {
            StringWriter tempWriter = new StringWriter(fragment.length());
            this.velocity.evaluate((Context)this.createContext(context), (Writer)tempWriter, "renderFragment", fragment);
            return tempWriter.toString();
        }
        catch (Exception e) {
            throw new RenderingException((Throwable)e);
        }
    }

    private VelocityContext createContext(Map<String, Object> contextParams) {
        return new VelocityContext(this.templateContextFactory.createContext(this.pluginKey, contextParams));
    }

    public boolean resolve(String templateName) {
        return this.classLoader.getResource(templateName) != null;
    }
}

