/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.websocket;

import com.atlassian.synchrony.proxy.util.SynchronyConfigInfo;
import com.atlassian.synchrony.proxy.websocket.WebSocketUpstreamHandler;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.WebSocketConnectionManager;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WebSocketProxy
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketProxy.class);
    private WebSocketUpstreamHandler webSocketUpstreamHandler;
    private WebSocketConnectionManager webSocketConnectionManager;
    private WebSocketClient webSocketClient = new StandardWebSocketClient();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        boolean isClusterManuallyManaged = Boolean.parseBoolean(System.getProperty("atlassian.internal.cluster.manually.managed", "false"));
        boolean isSynchronyUp = Boolean.parseBoolean(System.getProperty("atlassian.internal.synchrony.status", "true"));
        log.debug("Is cluster manually managed: {} isSynchronyUp {}", (Object)isClusterManuallyManaged, (Object)isSynchronyUp);
        if (isClusterManuallyManaged || !isSynchronyUp) {
            log.debug("Since cluster is manually managed or synchrony is not up hence not making connection with synchrony");
            session.close(CloseStatus.NORMAL);
            return;
        }
        String websocketUrl = SynchronyConfigInfo.fromSystemProperties().toWebSocketUri().toUriString();
        log.trace(">>> doHandshake for: {}", (Object)websocketUrl);
        this.webSocketUpstreamHandler = new WebSocketUpstreamHandler(session);
        this.webSocketConnectionManager = new WebSocketConnectionManager(this.webSocketClient, (WebSocketHandler)this.webSocketUpstreamHandler, websocketUrl, new Object[0]);
        this.webSocketConnectionManager.start();
        try {
            this.webSocketUpstreamHandler.getSynchronySession();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Handshake error", (Object)e.getMessage());
            log.debug("Handshake error", (Throwable)e);
            this.afterConnectionClosed(session, CloseStatus.SERVER_ERROR);
        }
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        log.trace(">>> text message limit: {}", (Object)this.webSocketUpstreamHandler.getSynchronySession().getTextMessageSizeLimit());
        log.trace(">>> message payload length: {}", (Object)message.getPayloadLength());
        log.trace("================================================================");
        try {
            this.webSocketUpstreamHandler.getSynchronySession().sendMessage((WebSocketMessage)message);
        }
        catch (Exception e) {
            log.error("Close the remote session and then the local session due to:  {}", (Object)e.getMessage());
            log.debug("", (Throwable)e);
            this.tryCloseRemoteSession();
            try {
                session.close();
            }
            catch (IOException e2) {
                log.error("Error occurred while closing the session downstream:", (Throwable)e2);
            }
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        log.trace("downstream connection closed. Reason ==> {}", (Object)status.getReason());
        this.tryCloseRemoteSession();
        try {
            log.debug("Attempt to close the session downstream");
            if (session.isOpen()) {
                session.close(status);
            }
        }
        catch (IOException e2) {
            log.error("Error closing session downstream:", (Throwable)e2);
        }
    }

    public boolean supportsPartialMessages() {
        return true;
    }

    private void tryCloseRemoteSession() throws Exception {
        try {
            WebSocketSession remoteSession;
            if (this.webSocketUpstreamHandler != null && (remoteSession = this.webSocketUpstreamHandler.getSynchronySession()) != null && remoteSession.isOpen()) {
                log.debug("Attempt to close the remoteSession upstream");
                remoteSession.close();
                this.webSocketConnectionManager.stop();
            }
        }
        catch (IOException e1) {
            log.error("Error occurred while closing the remoteSession upstream:", (Throwable)e1);
        }
    }
}

