/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.websocket;

import com.atlassian.synchrony.proxy.websocket.WebSocketProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.handler.PerConnectionWebSocketHandler;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConfig.class);
    private BeanFactory beanFactory;

    public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
        webSocketHandlerRegistry.addHandler((WebSocketHandler)this.perConnectionWebSocketHandler(), new String[]{"/v1/bayeux-sync1"}).setAllowedOrigins(new String[]{"*"});
    }

    public PerConnectionWebSocketHandler perConnectionWebSocketHandler() {
        PerConnectionWebSocketHandler handler = new PerConnectionWebSocketHandler(WebSocketProxy.class, true);
        handler.setBeanFactory(this.beanFactory);
        return handler;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

