/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.util;

import java.util.Objects;
import java.util.Properties;
import org.springframework.web.util.UriComponentsBuilder;

public class SynchronyConfigInfo {
    private final String synchronyHost;
    private final String synchronyContextPath;
    private final Integer synchronyPort;

    public SynchronyConfigInfo(String synchronyHost, String synchronyContextPath, Integer synchronyPort) {
        this.synchronyHost = synchronyHost;
        this.synchronyContextPath = synchronyContextPath;
        this.synchronyPort = synchronyPort;
    }

    public static SynchronyConfigInfo fromSystemProperties() {
        Properties sys = System.getProperties();
        return new SynchronyConfigInfo(sys.getProperty("synchrony.host", "127.0.0.1"), sys.getProperty("synchrony.context.path", sys.getProperty("reza.context.path", "/synchrony")), Integer.valueOf(Integer.parseInt(sys.getProperty("synchrony.port", sys.getProperty("reza.port", "8091")))));
    }

    public String getSynchronyContextPath() {
        return this.synchronyContextPath;
    }

    public String getSynchronyHost() {
        return this.synchronyHost;
    }

    public Integer getSynchronyPort() {
        return this.synchronyPort;
    }

    public UriComponentsBuilder toWebSocketUri() {
        return UriComponentsBuilder.newInstance().scheme("ws").host(this.synchronyHost).port(this.synchronyPort.intValue()).path(this.synchronyContextPath).path("/v1/bayeux-sync1");
    }

    public String toString() {
        return this.toWebSocketUri().toUriString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronyConfigInfo that = (SynchronyConfigInfo)o;
        return Objects.equals(this.synchronyHost, that.synchronyHost) && Objects.equals(this.synchronyContextPath, that.synchronyContextPath) && Objects.equals(this.synchronyPort, that.synchronyPort);
    }

    public int hashCode() {
        return Objects.hash(this.synchronyHost, this.synchronyContextPath, this.synchronyPort);
    }
}

