/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.zip;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.ActionWarning;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.zip.FileOptionsValidator;
import com.atlassian.support.tools.zip.FileSanitizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ZipUtility {
    public static final int MAX_BYTES_PER_FILE = 0x1900000;
    private static final Logger log = Logger.getLogger(FileOptionsValidator.class);

    public static File createSupportZip(List<ApplicationInfoBundle> applicationFileBundles, SupportApplicationInfo appInfo, ValidationLog validationLog) throws IOException {
        return ZipUtility.createSupportZip(applicationFileBundles, appInfo, validationLog, true);
    }

    public static File createSupportZip(List<ApplicationInfoBundle> applicationFileBundles, SupportApplicationInfo appInfo, ValidationLog validationLog, boolean limitFileSizes) throws IOException {
        File supportDir = new File(appInfo.getExportDirectory());
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            throw new IOException("Couldn't create export directory " + supportDir.getAbsolutePath());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String baseFilename = appInfo.getApplicationName() + "_support_" + format.format(new Date());
        String filename = baseFilename + ".zip";
        int counter = 0;
        while (new File(filename).exists()) {
            filename = baseFilename + "-" + ++counter + ".zip";
        }
        File supportZipFile = new File(supportDir, filename);
        ZipUtility.createSupportZip(supportZipFile, applicationFileBundles, appInfo, validationLog, limitFileSizes);
        return supportZipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSupportZip(File supportZip, List<ApplicationInfoBundle> applicationFileBundles, SupportApplicationInfo info, ValidationLog validationLog, boolean limitFileSizes) throws IOException {
        try {
            supportZip.createNewFile();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + " - " + supportZip.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(supportZip);
        try {
            ZipUtility.zip(out, applicationFileBundles, info, validationLog, limitFileSizes);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception e) {}
        }
        log.info((Object)("Saved Support Zip to: " + supportZip.getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(OutputStream destination, List<ApplicationInfoBundle> applicationFileBundles, SupportApplicationInfo info, ValidationLog validationLog, boolean limitFileSizes) throws IOException {
        TreeSet<String> filenames = new TreeSet<String>();
        ZipOutputStream out = new ZipOutputStream(destination);
        int entryCount = 0;
        try {
            out.setComment("zip, created by Support Tools Plugin");
            for (ApplicationInfoBundle applicationFileBundle : applicationFileBundles) {
                for (String filePath : applicationFileBundle.getFiles().keySet()) {
                    File file = new File(filePath);
                    if (!file.exists()) {
                        log.debug((Object)("Unable to find " + file.getName() + " for " + applicationFileBundle.getKey()));
                        continue;
                    }
                    if (file.isDirectory()) {
                        log.debug((Object)(file.getName() + " is a directory in " + applicationFileBundle.getKey()));
                        continue;
                    }
                    ++entryCount;
                    FileSanitizer sanitizer = info.getFileSanitizer();
                    String filename = file.getName();
                    int suffix = 0;
                    while (filenames.contains(filename)) {
                        filename = file.getName() + suffix++;
                    }
                    String subfolder = StringUtils.isEmpty((String)applicationFileBundle.getFiles().get(filePath)) ? "" : applicationFileBundle.getFiles().get(filePath) + "/";
                    String path = applicationFileBundle.getKey() + "/" + subfolder + filename;
                    log.debug((Object)("adding entry: " + file.getPath() + ", as " + path));
                    ZipEntry zentry = new ZipEntry(path);
                    zentry.setTime(file.lastModified());
                    out.putNextEntry(zentry);
                    ZipUtility.copyUpTo(out, sanitizer.sanitize(file), 0x1900000, info, validationLog, limitFileSizes);
                    out.closeEntry();
                    filenames.add(filename);
                }
            }
        }
        finally {
            if (entryCount > 0) {
                out.finish();
                out.close();
            } else {
                log.warn((Object)"No file entries were added to the zip file");
                destination.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyUpTo(OutputStream out, File file, int maxBytesToCopy, SupportApplicationInfo info, ValidationLog validationLog, boolean limitFileSizes) throws IOException {
        long totalSize = file.length();
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            int n;
            if (limitFileSizes && totalSize > (long)maxBytesToCopy) {
                validationLog.addWarning(new ActionWarning("File Truncated", info.getText("stp.zip.file.size.limited", (Serializable[])new String[]{file.getName(), "25Mb"})));
                f.skipBytes((int)(totalSize - (long)maxBytesToCopy));
            }
            byte[] buffer = new byte[4096];
            long count = 0L;
            while (-1 != (n = f.read(buffer))) {
                out.write(buffer, 0, n);
                count += (long)n;
            }
            out.flush();
            log.info((Object)("Copied " + count + " bytes for " + file.getName()));
        }
        finally {
            f.close();
        }
    }
}

