/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler.settings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.support.tools.scheduler.settings.ScheduledTaskSettings;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractScheduledTaskSettings
implements ScheduledTaskSettings {
    private static final Logger log = Logger.getLogger(AbstractScheduledTaskSettings.class);
    private static final int DEFAULT_FREQUENCY = 86400000;
    protected final PluginSettings settings;

    public AbstractScheduledTaskSettings(PluginSettingsFactory pluginSettingsFactory) {
        this.settings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public Date getStartTime() {
        String[] tokens;
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        String strVal = (String)this.settings.get(this.getTaskId() + ".startTime");
        if (!StringUtils.isEmpty((String)strVal) && (tokens = StringUtils.split((String)strVal, (char)':')).length == 2 && StringUtils.isNumeric((String)tokens[0]) && StringUtils.isNumeric((String)tokens[1])) {
            cal.set(11, Integer.parseInt(tokens[0]));
            cal.set(12, Integer.parseInt(tokens[1]));
        }
        return cal.getTime();
    }

    public void setStartTime(int hour, int min) {
        this.settings.put(this.getTaskId() + ".startTime", (Object)(hour + ":" + min));
    }

    @Override
    public String getFrequencyName() {
        if (this.getFrequencyMs() == 86400000L) {
            return "daily";
        }
        if (this.getFrequencyMs() == 604800000L) {
            return "weekly";
        }
        return null;
    }

    @Override
    public long getFrequencyMs() {
        String strVal = (String)this.settings.get(this.getTaskId() + ".frequency");
        if (StringUtils.isEmpty((String)strVal)) {
            return 86400000L;
        }
        if (!StringUtils.isNumeric((String)strVal)) {
            return 86400000L;
        }
        try {
            return Long.parseLong(strVal);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Failed to parse frequency for " + this.getTaskId() + " '" + strVal + "'"));
            return 86400000L;
        }
    }

    public void setFrequency(long frequency) {
        this.settings.put(this.getTaskId() + ".frequency", (Object)String.valueOf(frequency));
    }

    @Override
    public boolean isEnabled() {
        return "true".equals(this.settings.get(this.getTaskId() + ".enabled"));
    }

    public void setEnabled(boolean isEnabled) {
        this.settings.put(this.getTaskId() + ".enabled", (Object)String.valueOf(isEnabled));
    }
}

