/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.scheduler.SupportScheduledTaskController;
import com.atlassian.support.tools.scheduler.settings.ScheduledTaskSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.log4j.Logger;

public class SupportScheduledTaskControllerImpl
implements SupportScheduledTaskController {
    private static final Logger log = Logger.getLogger(SupportScheduledTaskControllerImpl.class);
    private final PluginScheduler pluginScheduler;
    private final Map<String, ScheduledTaskSettings> settingsMap = new HashMap<String, ScheduledTaskSettings>();
    private Map<String, Object> jobDataMap = new TreeMap<String, Object>();
    public static final String APP_INFO_KEY = "appInfo";
    public static final String MAIL_UTILITY_KEY = "mailUtility";

    private SupportScheduledTaskControllerImpl(PluginScheduler pluginScheduler, SupportApplicationInfo info, MailUtility mailUtility, ScheduledTaskSettings ... settingsArray) {
        this.pluginScheduler = pluginScheduler;
        this.jobDataMap.put(APP_INFO_KEY, info);
        this.jobDataMap.put(MAIL_UTILITY_KEY, mailUtility);
        for (ScheduledTaskSettings settings : settingsArray) {
            this.settingsMap.put(settings.getTaskId(), settings);
        }
    }

    @Override
    public ScheduledTaskSettings getTaskSettings(String id) {
        return this.settingsMap.get(id);
    }

    public void onStart() {
        log.debug((Object)"Starting support scheduled task controller...");
        for (ScheduledTaskSettings settings : this.settingsMap.values()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing startup checks for task type '" + settings.getTaskId() + "'"));
            }
            this.scheduleTask(settings);
        }
    }

    private void unscheduleTask(ScheduledTaskSettings settings) {
        block2: {
            try {
                this.pluginScheduler.unscheduleJob(settings.getTaskId());
            }
            catch (IllegalArgumentException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("I tried to unschedule task '" + settings.getTaskId() + "', but it wasn't running.  This is a normal safety check to ensure that disabled jobs are not run."), (Throwable)e);
            }
        }
    }

    private void scheduleTask(ScheduledTaskSettings settings) {
        if (!settings.isEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Scheduled task " + settings.getTaskId() + " is disabled."));
            }
            return;
        }
        TreeMap<String, Object> taskJobData = new TreeMap<String, Object>(this.jobDataMap);
        taskJobData.put("scheduledTaskSettings", settings);
        taskJobData.put("lastRunTracker", new MutableLong());
        this.pluginScheduler.scheduleJob(settings.getTaskId(), settings.getTaskClass(), taskJobData, settings.getStartTime(), settings.getFrequencyMs());
        if (log.isInfoEnabled()) {
            log.info((Object)("Task '" + settings.getTaskId() + "' will be executed every " + settings.getFrequencyMs() + " ms starting on " + settings.getStartTime() + "."));
        }
    }

    @Override
    public void onSettingsChanged(ScheduledTaskSettings settings) {
        this.unscheduleTask(settings);
        this.scheduleTask(settings);
    }
}

