/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.sisyphus.DefaultSisyphusPatternMatcher;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.support.tools.hercules.FileProgressMonitorInputStream;
import com.atlassian.support.tools.hercules.HerculesTools;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.hercules.WebMatchResultVisitor;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.scheduler.AbstractScheduledTask;
import com.atlassian.support.tools.scheduler.settings.HerculesScheduledTaskSettings;
import com.atlassian.support.tools.scheduler.utils.RenderingUtils;
import com.atlassian.templaterenderer.RenderingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;

public class ScheduledHerculesScanTask
extends AbstractScheduledTask {
    private static final Logger log = Logger.getLogger(ScheduledHerculesScanTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(Map<String, Object> jobDataMap) {
        MailUtility mailUtility = (MailUtility)jobDataMap.get("mailUtility");
        SupportApplicationInfo info = (SupportApplicationInfo)jobDataMap.get("appInfo");
        HerculesScheduledTaskSettings settings = (HerculesScheduledTaskSettings)jobDataMap.get("scheduledTaskSettings");
        if (mailUtility == null || info == null) {
            log.error((Object)"A required utility class was not provided, can't execute.");
            return;
        }
        List<ScanItem> applicationLogs = info.getApplicationLogFilePaths();
        if (applicationLogs == null || applicationLogs.size() == 0) {
            log.error((Object)"Couldn't find any application logs to scan, can't continue.");
            return;
        }
        String logFilePath = applicationLogs.get(0).getPath();
        File primaryLog = new File(logFilePath);
        if (!primaryLog.exists()) {
            log.error((Object)("Log file '" + logFilePath + "' doesn't exist, can't continue with the scan."));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Scanning log file '" + logFilePath + "'..."));
        }
        WebMatchResultVisitor visitor = new WebMatchResultVisitor(logFilePath);
        long time = System.currentTimeMillis();
        try {
            SisyphusPatternSource patternSource = info.getPatternSource();
            DefaultSisyphusPatternMatcher spm = new DefaultSisyphusPatternMatcher(patternSource);
            FileProgressMonitorInputStream in = new FileProgressMonitorInputStream(new File(logFilePath), visitor);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                spm.match(br, visitor);
            }
            catch (PatternSyntaxException e) {
                log.error((Object)"Invalid Hercules pattern found, results may be incomplete.", (Throwable)e);
            }
            catch (InterruptedException e) {
                visitor.setCancelled();
            }
            catch (IOException e) {
                visitor.scanFailed(e);
            }
            finally {
                visitor.scanCompleted();
                try {
                    br.close();
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (MalformedURLException e) {
            visitor.scanFailed(e);
        }
        catch (IOException e) {
            visitor.scanFailed(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error running scheduled Hercules scan:", (Throwable)e);
        }
        if (visitor.getScanException() != null) {
            log.error((Object)("There was an exception when scanning log file " + visitor.getLogFilePath() + " using Hercules: " + visitor.getScanException().getMessage()), (Throwable)visitor.getScanException());
            return;
        }
        if (visitor.getResults() == null || visitor.getResults().size() == 0) {
            log.warn((Object)("No results were returned when scanning log file " + visitor.getLogFilePath()));
            return;
        }
        log.info((Object)("Finished scanning " + visitor.getLogFilePath() + " using Hercules. Total size: " + visitor.getTotalSize() + " bytes. Time taken: " + (System.currentTimeMillis() - time) + " ms. Patterns matched: " + visitor.getResults().size()));
        log.info((Object)"Preparing hercules report...");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("info", info);
            params.put("fileName", FilenameUtils.getName((String)visitor.getLogFilePath()));
            params.put("results", visitor.getResults().values());
            params.put("scanException", visitor.getScanException());
            params.put("herculesTools", new HerculesTools());
            String mailBody = RenderingUtils.render(info.getTemplateRenderer(), "/templates/email/hercules-report.vm", params);
            String recipients = settings.getRecipients();
            ProductAwareEmail email = new ProductAwareEmail(recipients, info);
            email.setFrom(info.getFromAddress());
            email.setSubject(info.getText("stp.scheduler.hercules.mail.subject", new Serializable[]{DateFormatUtils.ISO_DATE_FORMAT.format(new Date())}));
            email.setBody(mailBody);
            email.setMimeType("text/html");
            log.info((Object)"Sending Hercules report...");
            mailUtility.sendMail(email);
        }
        catch (RenderingException e) {
            log.error((Object)("Error rendering Hercules report: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("I/O error while generating Hercules report: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected String getName() {
        return "Hercules scheduled log scan";
    }
}

