/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.scheduler;

import com.atlassian.sal.api.scheduling.PluginJob;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.log4j.Logger;

public abstract class AbstractScheduledTask
implements PluginJob {
    private static final Logger log = Logger.getLogger(AbstractScheduledTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, Object> jobDataMap) {
        MutableLong tracker = (MutableLong)jobDataMap.get("lastRunTracker");
        if (tracker.longValue() > System.currentTimeMillis() - 120000L) {
            log.warn((Object)("Refusing to run job '" + this.getName() + "' too often, last run at: " + new Date(tracker.longValue())));
            return;
        }
        tracker.setValue(System.currentTimeMillis());
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Executing scheduled task '" + this.getName() + "'..."));
            }
            this.doExecute(jobDataMap);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Error running scheduled task '" + this.getName() + "'..."), (Throwable)e);
            }
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)("Finished running scheduled task '" + this.getName() + "'..."));
            }
        }
    }

    protected abstract String getName();

    protected abstract void doExecute(Map<String, Object> var1);
}

