/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;

public class SupportRequestMailQueueItem
extends AbstractSupportMailQueueItem {
    private static final Logger log = Logger.getLogger(SupportRequestMailQueueItem.class);
    private final SupportRequest supportRequest;
    private final SupportApplicationInfo info;

    public SupportRequestMailQueueItem(SupportRequest supportRequest, SupportApplicationInfo info) {
        this.supportRequest = supportRequest;
        this.info = info;
    }

    public SupportRequest getSupportRequest() {
        return this.supportRequest;
    }

    public void send() throws MailException {
        ProductAwareEmail email = new ProductAwareEmail(this.supportRequest.getToAddress(), this.info);
        email.setFrom(this.supportRequest.getFromAddress());
        email.setSubject(this.supportRequest.getSubject());
        for (Map.Entry<String, String> entry : this.supportRequest.getHeaders()) {
            email.addHeader(entry.getKey(), entry.getValue());
        }
        Multipart bodyMimeMultipart = SupportRequestMailQueueItem.toMultiPart(this.supportRequest);
        email.setMultipart(bodyMimeMultipart);
        this.send(email);
    }

    public static Multipart toMultiPart(SupportRequest supportRequest) throws MailException {
        MimeMultipart bodyMimeMultipart = new MimeMultipart();
        try {
            if (supportRequest.getBody() != null) {
                MimeBodyPart textContent = new MimeBodyPart();
                textContent.setText(supportRequest.getBody());
                bodyMimeMultipart.addBodyPart((BodyPart)textContent);
            }
            for (SupportRequestAttachment attachment : supportRequest.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                if (attachment.getData() instanceof byte[]) {
                    ByteArrayDataSource fds = new ByteArrayDataSource((byte[])attachment.getData(), attachment.getType());
                    attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
                } else if (attachment.getData() instanceof String) {
                    attachmentPart.setText((String)((Object)attachment.getData()));
                } else {
                    log.error((Object)("Unrecognized attachment type: " + attachment.getData().getClass().getName()));
                }
                attachmentPart.setFileName(attachment.getName());
                log.debug((Object)("Adding attachment " + attachmentPart.getFileName()));
                bodyMimeMultipart.addBodyPart((BodyPart)attachmentPart);
            }
        }
        catch (MessagingException e) {
            throw new MailException(e.getMessage(), (Throwable)e);
        }
        return bodyMimeMultipart;
    }

    public String getSubject() {
        return this.supportRequest.getSubject();
    }
}

