/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.MailException;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.mail.MailService;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.log4j.Logger;

public class StashMailUtility
extends AbstractMailUtility {
    private static final Logger log = Logger.getLogger(AbstractMailUtility.class);
    private final MailService mailService;

    public StashMailUtility(MailService mailService) {
        this.mailService = mailService;
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailService.isHostConfigured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
            if (this.isMailServerConfigured()) {
                MailMessage.Builder builder = new MailMessage.Builder().from(requestInfo.getFromAddress()).subject(requestInfo.getSubject()).text(requestInfo.getBody()).to(new String[]{requestInfo.getToAddress()});
                for (Map.Entry<String, String> header : requestInfo.getHeaders()) {
                    builder.header(header.getKey(), header.getValue());
                }
                for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                    byte[] bytes;
                    Serializable data = attachment.getData();
                    if (data instanceof byte[]) {
                        bytes = (byte[])data;
                    } else if (data instanceof String) {
                        bytes = ((String)((Object)data)).getBytes();
                    } else {
                        log.warn((Object)("Attachment [" + attachment.getName() + "], of declared type [" + attachment.getType() + "], contains unexpected data: " + (data == null ? "(Null)" : data.getClass().getName()) + ". It will not be added to the mail message"));
                        continue;
                    }
                    builder.attachment(attachment.getName(), (DataSource)new ByteArrayDataSource(bytes, attachment.getType()));
                }
                this.mailService.submit(builder.build());
                log.info((Object)("Sent support request to " + requestInfo.getToAddress() + " using configured MailService"));
            } else {
                Properties props = new Properties();
                props.setProperty("mail.smtp.host", "mail.atlassian.com");
                props.put("mail.smtp.starttls.enable", String.valueOf(true));
                Session session = Session.getInstance((Properties)props);
                MimeMessage msg = new MimeMessage(session);
                msg.setContent(SupportRequestMailQueueItem.toMultiPart(requestInfo));
                msg.setFrom((Address)new InternetAddress(requestInfo.getFromAddress()));
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)requestInfo.getToAddress(), (boolean)false));
                msg.setSubject(requestInfo.getSubject());
                for (Map.Entry<String, String> entry : requestInfo.getHeaders()) {
                    msg.addHeader(entry.getKey(), entry.getValue());
                }
                Transport.send((Message)msg);
                log.info((Object)("Sent support request to " + requestInfo.getToAddress() + " using Atlassian mail server"));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(ProductAwareEmail email) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.mailService.getClass().getClassLoader());
            if (this.isMailServerConfigured()) {
                MailMessage message = new MailMessage.Builder().from(email.getFrom()).subject(email.getSubject()).text(email.getBody()).to(new String[]{email.getTo()}).build();
                this.mailService.submit(message);
            } else {
                try {
                    Properties props = new Properties();
                    props.setProperty("mail.smtp.host", "mail.atlassian.com");
                    props.put("mail.smtp.starttls.enable", String.valueOf(true));
                    Session session = Session.getInstance((Properties)props);
                    MimeMessage msg = new MimeMessage(session);
                    msg.setContent(email.getMultipart());
                    msg.setFrom((Address)new InternetAddress(email.getFrom()));
                    msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email.getTo(), (boolean)false));
                    msg.setSubject(email.getSubject());
                    for (Map.Entry entry : email.getHeaders().entrySet()) {
                        msg.addHeader(entry.getKey().toString(), entry.getValue().toString());
                    }
                    Transport.send((Message)msg);
                    SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
                    item.send();
                    log.debug((Object)("Sent message '" + item.getSubject() + "' using Atlassian's mail servers."));
                }
                catch (Exception e) {
                    log.error((Object)"Error sending mail using Atlassian's mail servers:", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

