/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.log4j.Logger;

public class ConfluenceMailUtility
extends AbstractMailUtility {
    private MultiQueueTaskManager taskManager;
    private static final Logger log = Logger.getLogger(ConfluenceMailUtility.class);

    public ConfluenceMailUtility(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    protected void queueSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, AddressException, MessagingException {
        SupportRequestMailQueueItem item = new SupportRequestMailQueueItem(requestInfo, info);
        this.taskManager.addTask("mail", (Task)item);
        log.debug((Object)("Added message '" + item.getSubject() + "' to the Confluence mail queue..."));
    }

    @Override
    public void sendMail(ProductAwareEmail email) {
        SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
        if (this.isMailServerConfigured()) {
            this.taskManager.addTask("mail", (Task)item);
            log.debug((Object)("Added message'" + item.getSubject() + "' to the Confluence mail queue..."));
        } else {
            try {
                item.send();
                log.debug((Object)("Sent message '" + item.getSubject() + "' using Atlassian's mail servers."));
            }
            catch (MailException e) {
                log.error((Object)"Error sending mail using Atlassian's mail servers:", (Throwable)e);
            }
        }
    }
}

