/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.ProductAwareEmail;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.log4j.Logger;

public class BambooMailUtility
extends AbstractMailUtility {
    private static final Logger log = Logger.getLogger(BambooMailUtility.class);

    @Override
    public boolean isMailServerConfigured() {
        MailServerManager serverManager = MailFactory.getServerManager();
        if (serverManager == null) {
            return false;
        }
        try {
            SMTPMailServer mailServer = serverManager.getDefaultSMTPMailServer();
            return mailServer != null;
        }
        catch (MailException e) {
            log.warn((Object)"Failed to obtain a mail server.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, AddressException, MessagingException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (MailFactory.getServerManager() != null) {
                Thread.currentThread().setContextClassLoader(MailFactory.getServerManager().getClass().getClassLoader());
            }
            SupportRequestMailQueueItem item = new SupportRequestMailQueueItem(requestInfo, info);
            item.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMail(ProductAwareEmail email) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (MailFactory.getServerManager() != null) {
                Thread.currentThread().setContextClassLoader(MailFactory.getServerManager().getClass().getClassLoader());
            }
            SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
            item.send();
        }
        catch (MailException e) {
            log.error((Object)"Error sending mail using Atlassian mail servers:", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

